<?php
/*
 * Copyright 2005-2015 Centreon
 * Centreon is developped by : Julien Mathis and Romain Le Merlus under
 * GPL Licence 2.0.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation ; either version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see <http://www.gnu.org/licenses>.
 *
 * Linking this program statically or dynamically with other modules is making a
 * combined work based on this program. Thus, the terms and conditions of the GNU
 * General Public License cover the whole combination.
 *
 * As a special exception, the copyright holders of this program give Centreon
 * permission to link this program with independent modules to produce an executable,
 * regardless of the license terms of these independent modules, and to copy and
 * distribute the resulting executable under terms of Centreon choice, provided that
 * Centreon also meet, for each linked independent module, the terms  and conditions
 * of the license of that module. An independent module is a module which is not
 * derived from this program. If you modify this program, you may extend this
 * exception to your version of the program, but you are not obliged to do so. If you
 * do not wish to do so, delete this exception statement from your version.
 *
 * For more information : contact@centreon.com
 *
 */

if (!isset($oreon)) {
    exit();
}

$DBRESULT = $pearDB->query("SELECT * FROM `options`");
while ($opt = $DBRESULT->fetchRow()) {
    $gopt[$opt["key"]] = myDecode($opt["value"]);
}
$DBRESULT->closeCursor();

$attrsText = ['size' => '40'];
$attrsText2 = ['size' => '5'];
$attrsAdvSelect = null;

$autocompleteOff = ['autocomplete' => 'new-password'];

// Form begin
$form = new HTML_QuickFormCustom('Form', 'post', "?p=" . $p);
$form->addElement('header', 'title', _("Modify Gorgone options"));

// Gorgone Options
$form->addElement('checkbox', 'enable_broker_stats', _("Enable Broker statistics collection"));
$form->addElement('text', 'gorgone_cmd_timeout', _("Timeout value for Gorgone commands"), $attrsText2);
$form->addRule('gorgone_cmd_timeout', _('Must be a number'), 'numeric');
$form->addElement('text', 'gorgone_illegal_characters', _("Illegal characters for Gorgone commands"), $attrsText);

// API
$form->addElement('text', 'gorgone_api_address', _("IP address or hostname"), $attrsText);
$form->addElement('text', 'gorgone_api_port', _("Port"), $attrsText2);
$form->addRule('gorgone_api_port', _('Must be a number'), 'numeric');
$form->addElement('text', 'gorgone_api_username', _("Username"), array_merge($attrsText, $autocompleteOff));
$form->addElement('password', 'gorgone_api_password', _("Password"), array_merge($attrsText, $autocompleteOff));
$form->addElement(
    'checkbox',
    'gorgone_api_ssl',
    _("Use SSL/TLS"),
    null
);
$form->setDefaults(1);
$form->addElement(
    'checkbox',
    'gorgone_api_allow_self_signed',
    _("Allow self signed certificate"),
    null
);
$form->setDefaults(1);

$form->addElement('hidden', 'gopt_id');
$redirect = $form->addElement('hidden', 'o');
$redirect->setValue($o);

$form->applyFilter('__ALL__', 'myTrim');

/*
 * Smarty template Init
 */
$tpl = new Smarty();
$tpl = initSmartyTpl($path . "/gorgone", $tpl);

$form->setDefaults($gopt);

$subC = $form->addElement('submit', 'submitC', _("Save"), ["class" => "btc bt_success"]);
$DBRESULT = $form->addElement('reset', 'reset', _("Reset"), ["class" => "btc bt_default"]);

// prepare help texts
$helptext = "";
include_once("help.php");
foreach ($help as $key => $text) {
    $helptext .= '<span style="display:none" id="help:' . $key . '">' . $text . '</span>' . "\n";
}
$tpl->assign("helptext", $helptext);

$valid = false;
if ($form->validate()) {
    //Update in DB
    updateGorgoneConfigData($pearDB, $form, $oreon);

    $o = null;
    $valid = true;
    $form->freeze();
}
if (!$form->validate() && isset($_POST["gopt_id"])) {
    print("<div class='msg' align='center'>" . _("impossible to validate, one or more field is incorrect") . "</div>");
}

$form->addElement(
    "button",
    "change",
    _("Modify"),
    ["onClick" => "javascript:window.location.href='?p=" . $p . "&o=gorgone'", 'class' => 'btc bt_info']
);

/*
 * Apply a template definition
 */
$renderer = new HTML_QuickForm_Renderer_ArraySmarty($tpl);
$renderer->setRequiredTemplate('{$label}&nbsp;<font color="red" size="1">*</font>');
$renderer->setErrorTemplate('<font color="red">{$error}</font><br />{$html}');
$form->accept($renderer);
$tpl->assign('form', $renderer->toArray());
$tpl->assign('o', $o);
$tpl->assign('valid', $valid);

$tpl->display("gorgone.ihtml");
