import { SvgIconProps } from '@mui/material';

import BaseIcon from './BaseIcon';

const icon = (
  <g>
    <path d="M22 10.07c-2.24 0-4.01-1.04-5.72-2.04-1.61-.94-3.13-1.83-4.96-1.83s-3.18.92-4.57 1.9c-1.33 1.16-3 1.85-4.76 1.97v-.83c1.7 0 2.95-.88 4.28-1.82 1.41-1.22 3.19-2.05 5.05-2.05 1.95 0 3.8.82 5.38 1.95 1.56 1.11 3.39 1.78 5.3 1.92v.83Z" />
    <path d="M22 14.07c-2.24 0-4.01-1.04-5.72-2.04-1.61-.94-3.13-1.83-4.96-1.83s-3.18.92-4.57 1.9c-1.33 1.16-3 1.85-4.76 1.97v-.83c1.7 0 2.95-.88 4.28-1.82 1.41-1.22 3.18-2.05 5.05-2.05 1.87 0 3.8.82 5.38 1.95 1.56 1.11 3.39 1.78 5.3 1.92v.83Z" />
    <path d="M22 18.07c-2.24 0-4.01-1.04-5.72-2.04-1.61-.94-3.13-1.83-4.96-1.83s-3.18.92-4.57 1.9c-1.33 1.16-3 1.85-4.76 1.97v-.83c1.7 0 2.95-.88 4.28-1.82 1.41-1.22 3.18-2.07 5.05-2.05 1.87.02 3.8.82 5.38 1.95 1.56 1.11 3.39 1.78 5.3 1.92v.83Z" />
  </g>
);

export const FlappingIcon = (props: SvgIconProps): JSX.Element => (
  <BaseIcon
    {...props}
    dataTestId="FlappingIcon"
    Icon={icon}
    height="24"
    viewBox="0 0 24 24"
    width="24"
  />
);
