<?php

/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

declare(strict_types=1);

namespace App\Shared\Infrastructure\Legacy;

use App\Kernel as LegacyKernel;
use Symfony\Component\DependencyInjection\Attribute\Lazy;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpKernel\KernelInterface;

/**
 * This class should be used **exceptionally**.
 * In most cases, the new app should never call the legacy.
 */
#[Lazy]
class LegacyContainer
{
    private ContainerInterface $legacyContainer;

    public function __construct(
        private KernelInterface $kernel,
    ) {
        $kernel = new LegacyKernel($this->kernel->getEnvironment(), $this->kernel->isDebug());
        $kernel->boot();

        $this->legacyContainer = $kernel->getContainer();
    }

    public function get(string $id): object
    {
        return $this->legacyContainer->get($id, ContainerInterface::EXCEPTION_ON_INVALID_REFERENCE);
    }
}
