<?php

/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

declare(strict_types=1);

namespace Tests\Security\Infrastructure\Authentication\Repository\Model;

use Core\Security\ProviderConfiguration\Domain\Model\Configuration;
use PHPUnit\Framework\TestCase;
use Security\Infrastructure\Repository\Model\ProviderConfigurationFactoryRdb;

/**
 * @package Tests\Security\Infrastructure\Authentication\API\Model_2110
 */
class ProviderConfigurationFactoryRdbTest extends TestCase
{
    /** @var array<string,int|string|bool> */
    private $dbData;

    protected function setUp(): void
    {
        $this->dbData = [
            'id' => 1,
            'type' => 'local',
            'name' => 'local',
            'is_active' => true,
            'is_forced' => true,
            'custom_configuration' => '{}',
        ];
    }

    /**
     * Tests model is properly created
     */
    public function testCreateWithAllProperties(): void
    {
        $providerConfiguration = ProviderConfigurationFactoryRdb::create($this->dbData);

        $this->assertInstanceOf(Configuration::class, $providerConfiguration);
        $this->assertEquals($this->dbData['id'], $providerConfiguration->getId());
        $this->assertEquals($this->dbData['type'], $providerConfiguration->getType());
        $this->assertEquals($this->dbData['name'], $providerConfiguration->getName());
        $this->assertEquals($this->dbData['is_active'], $providerConfiguration->isActive());
        $this->assertEquals($this->dbData['is_forced'], $providerConfiguration->isForced());
    }

    /**
     * Tests model is properly created
     */
    public function testCreateFromResponseWithMissingProperty(): void
    {
        $this->expectException(\InvalidArgumentException::class);
        $this->expectExceptionMessage("Missing mandatory parameter: 'is_forced'");

        $dbData = array_slice($this->dbData, 0, 4, true);
        ProviderConfigurationFactoryRdb::create($dbData);
    }
}
