<?php

/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

declare(strict_types=1);

$rectorConfig = require_once __DIR__ . '/../php-tools/rector/config/base.unstrict.php';

return $rectorConfig
    ->withCache(__DIR__ . '/var/cache/rector.legacy')
    ->withPaths([
        // directories
        __DIR__ . '/api',
        __DIR__ . '/config',
        __DIR__ . '/cron',
        __DIR__ . '/lib',
        __DIR__ . '/libinstall',
        __DIR__ . '/packaging',
        __DIR__ . '/src',
        __DIR__ . '/tests/php',
        __DIR__ . '/tools',
        __DIR__ . '/www',
        // files
        __DIR__ . '/bootstrap.php',
        __DIR__ . '/container.php',
    ])
    ->withSkip([
        // directories
        __DIR__ . '/www/class/centreon-clapi/',
        __DIR__ . '/src/Adaptation',
        __DIR__ . '/src/App',
        __DIR__ . '/src/Core',
        __DIR__ . '/tests/php/Adaptation',
        __DIR__ . '/tests/php/App',
        __DIR__ . '/tests/php/Core',
    ]);
