<?php

/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

declare(strict_types=1);

namespace App\ResourceConfiguration\Infrastructure\ApiPlatform\Transformer;

use App\ResourceConfiguration\Domain\Aggregate\ServiceCategory;
use App\ResourceConfiguration\Infrastructure\ApiPlatform\Resource\ServiceCategoryResource;
use App\Shared\Infrastructure\ApiPlatform\Transformer\TransformerInterface;

/**
 * @implements TransformerInterface<ServiceCategory, ServiceCategoryResource>
 */
final readonly class ServiceCategoryTransformer implements TransformerInterface
{
    public function toResource(object $model): ServiceCategoryResource
    {
        return new ServiceCategoryResource(
            id: $model->id()->value,
            name: $model->name->value,
            alias: $model->alias->value,
            isActivated: $model->activated,
        );
    }
}
