<?php

/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

declare(strict_types=1);

namespace Centreon\Infrastructure\Gorgone\Interfaces;

interface ConfigurationLoaderApiInterface
{
    /**
     * Indicates whether the connection to the Gorgone server used a self-signed certificate
     *
     * @throws \Exception
     * @return bool
     */
    public function isSecureConnectionSelfSigned(): bool;

    /**
     * Returns the IP address of the Gorgone server
     *
     * @throws \Exception
     * @return string|null IP address
     */
    public function getApiIpAddress(): ?string;

    /**
     * Returns the connection port of the Gorgone server
     *
     * @throws \Exception
     * @return int|null Connection port
     */
    public function getApiPort(): ?int;

    /**
     * Returns the API password of the Gorgone server
     *
     * @throws \Exception
     * @return string|null API password of the Gorgone server
     */
    public function getApiPassword(): ?string;

    /**
     * Returns the delay before the connection timeout
     *
     * @throws \Exception
     * @return int Timeout (in seconds)
     */
    public function getCommandTimeout(): int;

    /**
     * Indicates whether the connection to the Gorgone server is secure
     *
     * @throws \Exception
     * @return bool
     */
    public function isApiConnectionSecure(): bool;

    /**
     * Returns the API username of the Gorgone server
     *
     * @throws \Exception
     * @return string|null API username of the Gorgone server
     */
    public function getApiUsername(): ?string;
}
