<?php

/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

if (! isset($oreon)) {
    exit();
}

// Path to the configuration dir
$path = './include/configuration/configResources/';

// PHP functions
require_once $path . 'DB-Func.php';
require_once './include/common/common-Func.php';

/**
 *  Page forbidden if server is a remote
 */
if ($isRemote) {
    require_once $path . '../../core/errors/alt_error.php';

    exit();
}

define('MACRO_ADD', 'a');
define('MACRO_DELETE', 'd');
define('MACRO_DISABLE', 'u');
define('MACRO_DUPLICATE', 'm');
define('MACRO_ENABLE', 's');
define('MACRO_MODIFY', 'c');
define('MACRO_WATCH', 'w');

$action = filter_var(
    $_POST['o1'] ?? $_POST['o2'] ?? null,
    FILTER_VALIDATE_REGEXP,
    ['options' => ['regexp' => '/([a|c|d|m|s|u|w]{1})/']]
);
if ($action !== false) {
    $o = $action;
}

// If resource_id is not correctly typed, value will be set to false
$resourceId = filter_var(
    $_GET['resource_id'] ?? $_POST['resource_id'] ?? null,
    FILTER_VALIDATE_INT
);

// If one data are not correctly typed in array, it will be set to false
$selectIds = filter_var_array(
    $_GET['select'] ?? $_POST['select'] ?? [],
    FILTER_VALIDATE_INT
);

// If one data are not correctly typed in array, it will be set to false
$duplicateNbr = filter_var_array(
    $_GET['dupNbr'] ?? $_POST['dupNbr'] ?? [],
    FILTER_VALIDATE_INT
);

// Set the real page
if (isset($ret) && is_array($ret) && $ret['topology_page'] != '' && $p != $ret['topology_page']) {
    $p = $ret['topology_page'];
}

$acl = $oreon->user->access;
$serverString = $acl->getPollerString();
$allowedResourceConf = [];
if ($serverString != "''" && ! empty($serverString)) {
    $sql = 'SELECT resource_id
                FROM cfg_resource_instance_relations
                WHERE instance_id IN (' . $serverString . ')';
    $res = $pearDB->query($sql);
    while ($row = $res->fetchRow()) {
        $allowedResourceConf[$row['resource_id']] = true;
    }
}

switch ($o) {
    case MACRO_ADD:
        // Add a Resource
        require_once $path . 'formResources.php';
        break;
    case MACRO_WATCH:
        // Watch a Resource
        require_once $path . 'formResources.php';
        break;
    case MACRO_MODIFY:
        // Modify a Resource
        require_once $path . 'formResources.php';
        break;
    case MACRO_ENABLE:
        // Activate a Resource
        purgeOutdatedCSRFTokens();
        if (isCSRFTokenValid()) {
            purgeCSRFToken();
            if ($resourceId !== false) {
                enableResourceInDB($resourceId);
            }
        } else {
            unvalidFormMessage();
        }
        require_once $path . 'listResources.php';
        break;
    case MACRO_DISABLE:
        // Desactivate a Resource
        purgeOutdatedCSRFTokens();
        if (isCSRFTokenValid()) {
            purgeCSRFToken();
            if ($resourceId !== false) {
                disableResourceInDB($resourceId);
            }
        } else {
            unvalidFormMessage();
        }
        require_once $path . 'listResources.php';
        break;
    case MACRO_DUPLICATE:
        // Duplicate n resources only if data sent are correctly typed
        purgeOutdatedCSRFTokens();
        if (isCSRFTokenValid()) {
            purgeCSRFToken();
            if (! in_array(false, $selectIds) && ! in_array(false, $duplicateNbr)) {
                multipleResourceInDB(
                    $selectIds,
                    $duplicateNbr
                );
            }
        } else {
            unvalidFormMessage();
        }
        require_once $path . 'listResources.php';
        break;
    case MACRO_DELETE:
        // Delete n resources only if data sent are correctly typed
        purgeOutdatedCSRFTokens();
        if (isCSRFTokenValid()) {
            purgeCSRFToken();
            if (! in_array(false, $selectIds)) {
                deleteResourceInDB($selectIds);
            }
        } else {
            unvalidFormMessage();
        }
        require_once $path . 'listResources.php';
        break;
    default:
        require_once $path . 'listResources.php';
        break;
}
