<?php

/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

namespace CentreonLegacy\Core\Module;

use Centreon\Test\Mock\DependencyInjector\ServiceContainer;
use CentreonLegacy\ServiceProvider;
use Pimple\Container;

/**
 * Class
 *
 * @class FactoryTest
 * @package CentreonLegacy\Core\Module
 */
class FactoryTest extends \PHPUnit\Framework\TestCase
{
    /** @var ServiceContainer */
    public $container;

    public function setUp(): void
    {
        $this->container = new ServiceContainer();

        $this->container[ServiceProvider::CENTREON_LEGACY_MODULE_INFORMATION] = $this
            ->getMockBuilder(Information::class)
            ->disableOriginalConstructor()
            ->getMock();

        $this->container[ServiceProvider::CENTREON_LEGACY_MODULE_LICENSE] = $this
            ->getMockBuilder(License::class)
            ->disableOriginalConstructor()
            ->getMock();

        $this->container[ServiceProvider::CENTREON_LEGACY_MODULE_INSTALLER] = function (Container $container) {
            return function ($moduleName) {
                return $this->getMockBuilder(Installer::class)
                    ->disableOriginalConstructor()
                    ->getMock();
            };
        };

        $this->container[ServiceProvider::CENTREON_LEGACY_MODULE_UPGRADER] = function (Container $container) {
            return function ($moduleName, $moduleId) {
                return $this->getMockBuilder(Upgrader::class)
                    ->disableOriginalConstructor()
                    ->getMock();
            };
        };

        $this->container[ServiceProvider::CENTREON_LEGACY_MODULE_REMOVER] = function (Container $container) {
            return function ($moduleName, $moduleId) {
                return $this->getMockBuilder(Remover::class)
                    ->disableOriginalConstructor()
                    ->getMock();
            };
        };
    }

    public function tearDown(): void
    {
        $this->container->terminate();
        $this->container = null;
    }

    public function testNewInformation(): void
    {
        $factory = new Factory($this->container);
        $this->assertInstanceOf(Information::class, $factory->newInformation());
    }

    public function testNewInstaller(): void
    {
        $factory = new Factory($this->container);
        $this->assertInstanceOf(Installer::class, $factory->newInstaller('MyModule'));
    }

    public function testNewUpgrader(): void
    {
        $factory = new Factory($this->container);
        $this->assertInstanceOf(Upgrader::class, $factory->newUpgrader('MyModule', 1));
    }

    public function testNewRemover(): void
    {
        $factory = new Factory($this->container);
        $this->assertInstanceOf(Remover::class, $factory->newRemover('MyModule', 1));
    }

    public function testNewLicense(): void
    {
        $factory = new Factory($this->container);
        $this->assertInstanceOf(License::class, $factory->newLicense());
    }
}
