<?php

/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

use Core\Infrastructure\Common\Api\Router;

beforeEach(function (): void {
    $this->router = new Router(
        $this->createMock(Symfony\Component\Routing\RouterInterface::class),
        $this->createMock(Symfony\Component\Routing\Matcher\RequestMatcherInterface::class)
    );
});

it('should return a legacy path without options', function (): void {
    $legacyHref = $this->router->generateLegacyHref(60202);
    expect($legacyHref)->toBe('/main.php?p=60202');
});

it('should return a legacy path with options', function (): void {
    $legacyHref = $this->router->generateLegacyHref(60202, ['foo' => 'bar']);
    expect($legacyHref)->toBe('/main.php?p=60202&foo=bar');
});
