<?php

/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

declare(strict_types=1);

namespace Core\MonitoringServer\Application\UseCase\UpdateMonitoringServer;

use Core\MonitoringServer\Application\Repository\ReadMonitoringServerRepositoryInterface;
use Core\MonitoringServer\Application\Repository\WriteMonitoringServerRepositoryInterface;

final readonly class UpdateMonitoringServer
{
    public function __construct(
        private WriteMonitoringServerRepositoryInterface $writeRepository,
        private ReadMonitoringServerRepositoryInterface $readRepository,
    ) {
    }

    public function __invoke(UpdateMonitoringServerRequest $request): void
    {
        $monitoringServer = $this->readRepository->get($request->id);

        $monitoringServer->update(
            name: $request->name,
            engineStartCommand: $request->engineStartCommand,
            engineStopCommand: $request->engineStopCommand,
            engineRestartCommand: $request->engineRestartCommand,
            engineReloadCommand: $request->engineReloadCommand,
            brokerReloadCommand: $request->brokerReloadCommand
        );

        $this->writeRepository->update($monitoringServer);
    }
}
