<?php

/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

if (! isset($centreon)) {
    exit();
}

include_once './class/centreonUtils.class.php';

include './include/common/autoNumLimit.php';

$search = HtmlAnalyzer::sanitizeAndRemoveTags(
    $_POST['searchMS'] ?? $_GET['searchMS'] ?? null
);

if (isset($_POST['searchMS']) || isset($_GET['searchMS'])) {
    // saving filters values
    $centreon->historySearch[$url] = [];
    $centreon->historySearch[$url]['search'] = $search;
} else {
    // restoring saved values
    $search = $centreon->historySearch[$url]['search'] ?? null;
}

// Meta Service list
$rq = 'SELECT SQL_CALC_FOUND_ROWS * FROM meta_service ';
if ($search) {
    $rq .= "WHERE meta_name LIKE '%" . $search . "%' "
        . $acl->queryBuilder('AND', 'meta_id', $metaStr);
} else {
    $rq .= $acl->queryBuilder('WHERE', 'meta_id', $metaStr);
}
$rq .= ' ORDER BY meta_name LIMIT ' . $num * $limit . ', ' . $limit;

$dbResult = $pearDB->query($rq);
$rows = $pearDB->query('SELECT FOUND_ROWS()')->fetchColumn();

include './include/common/checkPagination.php';

// Smarty template initialization
$tpl = SmartyBC::createSmartyTemplate($path);

// Access level
$lvl_access = ($centreon->user->access->page($p) == 1) ? 'w' : 'r';
$tpl->assign('mode_access', $lvl_access);

// start header menu
$tpl->assign('headerMenu_name', _('Name'));
$tpl->assign('headerMenu_type', _('Calculation Type'));
$tpl->assign('headerMenu_levelw', _('Warning Level'));
$tpl->assign('headerMenu_levelc', _('Critical Level'));
$tpl->assign('headerMenu_status', _('Status'));
$tpl->assign('headerMenu_options', _('Options'));

$calcType = ['AVE' => _('Average'), 'SOM' => _('Sum'), 'MIN' => _('Min'), 'MAX' => _('Max')];

// Meta Service list
$conditionStr = '';
$metaStrParams = [];
// binding query params for non admin  acl rules
$searchIsNull = $search === null || $search === '';
// the metaStr are the metas linked to the user's ACL
if ($acl->admin === '0' || $acl->admin === false) {
    if ($metaStr === "''" || $metaStr === '') {
        $queryParams = '0';
    } else {
        $metaStrList = explode(',', $metaStr);
        foreach ($metaStrList as $index => $metaId) {
            $metaStrParams[':meta_' . $index] = (int) str_replace("'", '', $metaId);
        }
        $queryParams = implode(',', array_keys($metaStrParams));
    }
    $conditionStr = ! $searchIsNull ? 'AND meta_id IN (' . $queryParams . ')' : 'WHERE meta_id IN (' . $queryParams . ')';
}
if (! $searchIsNull) {
    $statement = $pearDB->prepare('SELECT * FROM meta_service '
        . 'WHERE meta_name LIKE :search ' . $conditionStr
        . ' ORDER BY meta_name LIMIT :offset, :limit');
    $statement->bindValue(':search', '%' . $search . '%', PDO::PARAM_STR);
} else {
    $statement = $pearDB->prepare('SELECT * FROM meta_service ' . $conditionStr
        . ' ORDER BY meta_name LIMIT :offset, :limit');
}
foreach ($metaStrParams as $key => $metaId) {
    $statement->bindValue($key, $metaId, PDO::PARAM_INT);
}
$statement->bindValue(':offset', (int) $num * (int) $limit, PDO::PARAM_INT);
$statement->bindValue(':limit', $limit, PDO::PARAM_INT);
$statement->execute();

$form = new HTML_QuickFormCustom('select_form', 'GET', '?p=' . $p);

// Different style between each lines
$style = 'one';

$attrBtnSuccess = ['class' => 'btc bt_success', 'onClick' => "window.history.replaceState('', '', '?p=" . $p . "');"];
$form->addElement('submit', 'Search', _('Search'), $attrBtnSuccess);

// Fill a tab with a multidimensional Array we put in $tpl
$elemArr = [];
$centreonToken = createCSRFToken();

for ($i = 0; $ms = $statement->fetch(PDO::FETCH_ASSOC); $i++) {
    $moptions = '';
    $selectedElements = $form->addElement('checkbox', 'select[' . $ms['meta_id'] . ']');
    if ($ms['meta_select_mode'] == 1) {
        $moptions = "<a href='main.php?p=" . $p . '&meta_id=' . $ms['meta_id'] . '&o=ci&search='
            . $search . "'><img src='img/icons/redirect.png' class='ico-16' border='0' alt='"
            . _('View') . "'></a>&nbsp;&nbsp;";
    } else {
        $moptions = '';
    }

    if ($ms['meta_activate']) {
        $moptions .= "<a href='main.php?p=" . $p . '&meta_id=' . $ms['meta_id'] . '&o=u&limit=' . $limit
            . '&num=' . $num . '&search=' . $search . '&centreon_token=' . $centreonToken
            . "'><img src='img/icons/disabled.png' class='ico-14 margin_right' "
            . "border='0' alt='" . _('Disabled') . "'></a>&nbsp;&nbsp;";
    } else {
        $moptions .= "<a href='main.php?p=" . $p . '&meta_id=' . $ms['meta_id'] . '&o=s&limit=' . $limit
            . '&num=' . $num . '&search=' . $search . '&centreon_token=' . $centreonToken
            . "'><img src='img/icons/enabled.png' class='ico-14 margin_right' "
            . "border='0' alt='" . _('Enabled') . "'></a>&nbsp;&nbsp;";
    }
    $moptions .= '&nbsp;';

    $moptions .= '<input onKeypress="if(event.keyCode > 31 && (event.keyCode < 45 || event.keyCode > 57)) '
        . 'event.returnValue = false; if(event.which > 31 && (event.which < 45 || event.which > 57)) '
        . "return false;\" maxlength=\"3\" size=\"3\" value='1' style=\"margin-bottom:0px;\" "
        . "name='dupNbr[" . $ms['meta_id'] . "]' />";

    $elemArr[$i] = ['MenuClass' => 'list_' . $style, 'RowMenu_select' => $selectedElements->toHtml(), 'RowMenu_name' => CentreonUtils::escapeSecure($ms['meta_name']), 'RowMenu_link' => 'main.php?p=' . $p . '&o=c&meta_id=' . $ms['meta_id'], 'RowMenu_type' => CentreonUtils::escapeSecure($calcType[$ms['calcul_type']]), 'RowMenu_levelw' => isset($ms['warning']) && $ms['warning'] ? $ms['warning'] : '-', 'RowMenu_levelc' => isset($ms['critical']) && $ms['critical'] ? $ms['critical'] : '-', 'RowMenu_status' => $ms['meta_activate'] ? _('Enabled') : _('Disabled'), 'RowMenu_badge' => $ms['meta_activate'] ? 'service_ok' : 'service_critical', 'RowMenu_options' => $moptions];
    $style = $style != 'two' ? 'two' : 'one';
}
$tpl->assign('elemArr', $elemArr);

// Different messages we put in the template
$tpl->assign(
    'msg',
    ['addL' => 'main.php?p=' . $p . '&o=a', 'addT' => _('Add'), 'delConfirm' => _('Do you confirm the deletion ?')]
);

// Toolbar select
?>
<script type="text/javascript">
    function setO(_i) {
        document.forms['form'].elements['o'].value = _i;
    }
</script>
<?php

$attrs1 = ['onchange' => 'javascript: '
    . ' var bChecked = isChecked(); '
    . " if (this.form.elements['o1'].selectedIndex != 0 && !bChecked) {"
    . " alert('" . _('Please select one or more items') . "'); return false;} "
    . "if (this.form.elements['o1'].selectedIndex == 1 && confirm('"
    . _('Do you confirm the duplication ?') . "')) {"
    . " 	setO(this.form.elements['o1'].value); submit();} "
    . "else if (this.form.elements['o1'].selectedIndex == 2 && confirm('"
    . _('Do you confirm the deletion ?') . "')) {"
    . " 	setO(this.form.elements['o1'].value); submit();} "
    . "else if (this.form.elements['o1'].selectedIndex == 3) {"
    . " 	setO(this.form.elements['o1'].value); submit();} "
    . ''];
$form->addElement(
    'select',
    'o1',
    null,
    [null => _('More actions...'), 'm' => _('Duplicate'), 'd' => _('Delete')],
    $attrs1
);
$form->setDefaults(['o1' => null]);

$attrs2 = ['onchange' => 'javascript: '
    . ' var bChecked = isChecked(); '
    . " if (this.form.elements['o2'].selectedIndex != 0 && !bChecked) {"
    . " alert('" . _('Please select one or more items') . "'); return false;} "
    . "if (this.form.elements['o2'].selectedIndex == 1 && confirm('"
    . _('Do you confirm the duplication ?') . "')) {"
    . " 	setO(this.form.elements['o2'].value); submit();} "
    . "else if (this.form.elements['o2'].selectedIndex == 2 && confirm('"
    . _('Do you confirm the deletion ?') . "')) {"
    . " 	setO(this.form.elements['o2'].value); submit();} "
    . "else if (this.form.elements['o2'].selectedIndex == 3) {"
    . " 	setO(this.form.elements['o2'].value); submit();} "
    . ''];
$form->addElement(
    'select',
    'o2',
    null,
    [null => _('More actions...'), 'm' => _('Duplicate'), 'd' => _('Delete')],
    $attrs2
);
$form->setDefaults(['o2' => null]);

$o1 = $form->getElement('o1');
$o1->setValue(null);
$o1->setSelected(null);

$o2 = $form->getElement('o2');
$o2->setValue(null);
$o2->setSelected(null);

$tpl->assign('limit', $limit);
$tpl->assign('searchMS', $search);

// Apply a template definition
$renderer = new HTML_QuickForm_Renderer_ArraySmarty($tpl);
$form->accept($renderer);
$tpl->assign('form', $renderer->toArray());
$tpl->display('listMetaService.ihtml');
