<?php

/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

declare(strict_types=1);

namespace Centreon\Domain\Monitoring\Metric\Interfaces;

use Centreon\Domain\Contact\Interfaces\ContactInterface;
use Centreon\Domain\Monitoring\Service;

interface MetricRepositoryInterface
{
    /**
     * Find metrics data linked to a service.
     *
     * @param Service $service
     * @param \DateTimeInterface $start start date
     * @param \DateTimeInterface $end end date
     * @throws \Exception
     * @return array
     */
    public function findMetricsByService(Service $service, \DateTimeInterface $start, \DateTimeInterface $end): array;

    /**
     * Find status data linked to a service.
     *
     * @param Service $service
     * @param \DateTimeInterface $start start date
     * @param \DateTimeInterface $end end date
     * @throws \Exception
     * @return array
     */
    public function findStatusByService(Service $service, \DateTimeInterface $start, \DateTimeInterface $end): array;

    /**
     * @param ContactInterface $contact
     * @return self
     */
    public function setContact(ContactInterface $contact): self;
}
