<?php

/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

declare(strict_types=1);

namespace Core\Security\ProviderConfiguration\Application\SAML\Repository;

use Core\Common\Domain\Exception\RepositoryException;
use Core\Security\ProviderConfiguration\Domain\Model\AuthorizationRule;
use Core\Security\ProviderConfiguration\Domain\Model\Configuration;
use Core\Security\ProviderConfiguration\Domain\Model\ContactGroupRelation;

interface WriteSAMLConfigurationRepositoryInterface
{
    /**
     * @throws RepositoryException
     */
    public function updateConfiguration(Configuration $configuration): void;

    /**
     * @throws RepositoryException
     */
    public function deleteAuthorizationRules(): void;

    /**
     * @param AuthorizationRule[] $authorizationRules
     *
     * @throws RepositoryException
     */
    public function insertAuthorizationRules(array $authorizationRules): void;

    /**
     * @throws RepositoryException
     */
    public function deleteContactGroupRelations(): void;

    /**
     * @param ContactGroupRelation[] $contactGroupRelations
     *
     * @throws RepositoryException
     */
    public function insertContactGroupRelations(array $contactGroupRelations): void;
}
