<?php
/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

if (! isset($centreon)) {
    exit();
}

if (! isset($centreon->optGen['AjaxFirstTimeReloadMonitoring'])
    || $centreon->optGen['AjaxFirstTimeReloadMonitoring'] == 0
) {
    $tFM = 10;
} else {
    $tFM = $centreon->optGen['AjaxFirstTimeReloadMonitoring'] * 1000;
}

if (! isset($centreon->optGen['AjaxFirstTimeReloadStatistic'])
    || $centreon->optGen['AjaxFirstTimeReloadStatistic'] == 0
) {
    $tFS = 10;
} else {
    $tFS = $centreon->optGen['AjaxFirstTimeReloadStatistic'] * 1000;
}

$sid = session_id();
$time = time();

$obis = $o;
if (isset($_GET['problem'])) {
    $obis .= '_pb';
}
if (isset($_GET['acknowledge'])) {
    $obis .= '_ack_' . $_GET['acknowledge'];
}

?>
<script type="text/javascript">

    var _debug = 0;

    var _addrXML = "./include/monitoring/status/Hosts/xml/hostXML.php";
    var _addrXSL = "./include/monitoring/status/Hosts/xsl/host.xsl";
    var _criticality_id = 0;

    <?php include_once './include/monitoring/status/Common/commonJS.php'; ?>

    var _selectedElem = new Array();

    function set_header_title() {

        var _img_asc = mk_imgOrder('./img/icones/7x7/sort_asc.gif', "asc");
        var _img_desc = mk_imgOrder('./img/icones/7x7/sort_desc.gif', "desc");

        if (document.getElementById('host_name')) {
            var h = document.getElementById('host_name');
            h.innerHTML = '<?php echo addslashes(_('Hosts')); ?>';
            h.indice = 'host_name';
            h.onclick = function () {
                change_type_order(this.indice)
            };
            h.style.cursor = "pointer";

            var h = document.getElementById('current_state');
            h.innerHTML = '<?php echo addslashes(_('Status')); ?>';
            h.indice = 'current_state';
            h.onclick = function () {
                change_type_order(this.indice)
            };
            h.style.cursor = "pointer";

            var h = document.getElementById('ip');
            h.innerHTML = '<?php echo addslashes(_('IP Address')); ?>';
            h.indice = 'ip';
            h.onclick = function () {
                change_type_order(this.indice)
            };
            h.style.cursor = "pointer";

            var h = document.getElementById('last_state_change');
            h.innerHTML = '<?php echo addslashes(_('Duration')); ?>';
            h.indice = 'last_state_change';
            h.onclick = function () {
                change_type_order(this.indice)
            };
            h.style.cursor = "pointer";

            var h = document.getElementById('last_hard_state_change');
            if (h) {
                h.innerHTML = '<?php echo addslashes(_('Hard State Duration')); ?>';
                h.indice = 'last_hard_state_change';
                h.onclick = function () {
                    change_type_order(this.indice)
                };
                h.style.cursor = "pointer";
            }

            var h = document.getElementById('last_check');
            h.innerHTML = '<?php echo addslashes(_('Last Check')); ?>';
            h.indice = 'last_check';
            h.onclick = function () {
                change_type_order(this.indice)
            };
            h.style.cursor = "pointer";

            var h = document.getElementById('current_check_attempt');
            h.innerHTML = '<?php echo addslashes(_('Tries')); ?>';
            h.indice = 'current_check_attempt';
            h.onclick = function () {
                change_type_order(this.indice)
            };
            h.style.cursor = "pointer";

            var h = document.getElementById('criticality_id');
            if (h) {
                h.innerHTML = '<?php echo addslashes('S'); ?>';
                h.indice = 'criticality_id';
                h.title = "<?php echo _('Sort by severity'); ?>";
                h.onclick = function () {
                    change_type_order(this.indice)
                };
                h.style.cursor = "pointer";
            }

            var h = document.getElementById('plugin_output');
            h.innerHTML = '<?php echo addslashes(_('Status information')); ?>';
            h.indice = 'plugin_output';
            h.onclick = function () {
                change_type_order(this.indice)
            };
            h.style.cursor = "pointer";

            if (_sort_type) {
                var h = document.getElementById(_sort_type);
                var _linkaction_asc = document.createElement("a");
                if (_order == 'ASC') {
                    _linkaction_asc.appendChild(_img_asc);
                } else {
                    _linkaction_asc.appendChild(_img_desc);
                }
                _linkaction_asc.href = '#';
                _linkaction_asc.onclick = function () {
                    change_order()
                };
                if (h) {
                    h.appendChild(_linkaction_asc);
                }
            }
        }
    }

    function mainLoopHost() {

        _currentInputField = document.getElementById('host_search');
        if (document.getElementById('host_search') && document.getElementById('host_search').value) {
            _currentInputFieldValue = document.getElementById('host_search').value;
        } else {
            _currentInputFieldValue = "";
        }

        if ((_currentInputFieldValue.length >= 3 || _currentInputFieldValue.length == 0) &&
            _oldInputFieldValue != _currentInputFieldValue
        ) {
            if (!_lock) {
                set_search_host(escapeURI(_currentInputFieldValue));
                _host_search = _currentInputFieldValue;

                monitoring_refresh();

                if (_currentInputFieldValue.length >= 3) {
                    _currentInputField.className = "search_input_active";
                } else {
                    _currentInputField.className = "search_input";
                }
            }
        }
        _oldInputFieldValue = _currentInputFieldValue;

        setTimeout(mainLoopHost, 250);
    }

    function initM(_time_reload, _o) {

        // INIT Select objects
        construct_selecteList_ndo_instance('instance_selected');
        construct_HostGroupSelectList('hostgroups_selected');

        if (document.getElementById("host_search") && document.getElementById("host_search").value) {
            _host_search = document.getElementById("host_search").value;
            viewDebugInfo('service search: ' + document.getElementById("host_search").value);
        } else if (document.getElementById("host_search").length == 0) {
            _host_search = "";
        }

        if (document.getElementById("critFilter") && document.getElementById("critFilter").value) {
            _criticality_id = document.getElementById("critFilter").value;
            viewDebugInfo('Host criticality: ' + document.getElementById("critFilter").value);
        }

        if (_first) {
            mainLoopHost();
            _first = 0;
        }

        _time =<?php echo $time; ?>;
        if (_on) {
            goM(_time_reload, _o);
        }
    }

    function goM(_time_reload, _o) {
        if (_on == 0) {
            return;
        }
        _lock = 1;
        var proc = new Transformation();

        // INIT search informations
        if (_counter == 0) {
            document.getElementById("host_search").value = _host_search;
            _counter += 1;
        }

        var statusHost = jQuery.trim(jQuery('#statusHost').val());
        var statusFilter = jQuery.trim(jQuery('#statusFilter').val());

        proc.setCallback(function(t){monitoringCallBack(t); proc = null;});
        proc.setXml(_addrXML + "?" + 'search=' + _host_search + '&num=' + _num + '&limit=' + _limit +
            '&sort_type=' + _sort_type + '&order=' + _order + '&date_time_format_status=' + _date_time_format_status +
            '&o=' + _o + '&p=' + _p + '&time=<?php echo time(); ?>&criticality=' + _criticality_id +
            '&statusHost=' + statusHost + '&statusFilter=' + statusFilter + "&sSetOrderInMemory=" + sSetOrderInMemory
        );
        proc.setXslt(_addrXSL);
        if (handleVisibilityChange()) {
            proc.transform("forAjax");
        }

        _lock = 0;
        if (_timeoutID) { // Kill next execution if in queue
            clearTimeout(_timeoutID);
        }
        _timeoutID = cycleVisibilityChange(function(){goM(_time_reload, _o)}, _time_reload);
        _time_live = _time_reload;
        _on = 1;

        set_header_title();
    }

    function unsetCheckboxes() {
        for (keyz in _selectedElem) {
            if (keyz == _selectedElem[keyz]) {
                removeFromSelectedElem(decodeURIComponent(keyz));
                if (document.getElementById(decodeURIComponent(keyz))) {
                    document.getElementById(decodeURIComponent(keyz)).checked = false;
                }
            }
        }
    }

    function cmdCallback(cmd) {
        jQuery('.centreon-popin').remove();
        var keyz;

        _cmd = cmd;
        var resources = [];
        _getVar = "";
        if (cmd != '72' && cmd != '75') {
            return 1;
        } else {
            for (keyz in _selectedElem) {
                if ((keyz == _selectedElem[keyz]) &&
                    typeof(document.getElementById(decodeURIComponent(keyz)) != 'undefined') &&
                    document.getElementById(decodeURIComponent(keyz))
                ) {
                    if (document.getElementById(decodeURIComponent(keyz)).checked) {
                        resources.push(encodeURIComponent(keyz));
                    }
                }
            }

            _getVar = JSON.stringify(resources)
            var url = './include/monitoring/external_cmd/popup/popup.php?o=' + _o + '&p=' + _p +
                '&cmd=' + cmd;

            var popin = jQuery('<div>');
            popin.centreonPopin({open: true, url: url});
            window.currentPopin = popin;
            return 0;
        }
    }

    function send_the_command() {
        if (window.XMLHttpRequest) {
            xhr_cmd = new XMLHttpRequest();
        }
        else if (window.ActiveXObject) {
            xhr_cmd = new ActiveXObject("Microsoft.XMLHTTP");
        }
        var comment = encodeURIComponent(document.getElementById('popupComment').value.trim());
        if (comment == "") {
            alert(_popup_no_comment_msg);
            return 0;
        }
        if (_cmd == '70' || _cmd == '72') {

            if (document.getElementById('sticky')) {
                var sticky = document.getElementById('sticky').checked;
            } else
                var sticky = 1;

            if (document.getElementById('persistent')) {
                var persistent = document.getElementById('persistent').checked;
            } else {
                var persistent = 1;
            }

            if (document.getElementById('notify')) {
                var notify = document.getElementById('notify').checked;
            } else {
                var notify = 0;
            }

            if (document.getElementById('force_check')) {
                var force_check = document.getElementById('force_check').checked;
            } else {
                var force_check = 0;
            }

            var ackhostservice = 0;
            if (document.getElementById('ackhostservice')) {
                ackhostservice = document.getElementById('ackhostservice').checked;
            }

            var author = document.getElementById('author').value;

            xhr_cmd.open(
                "POST",
                "./include/monitoring/external_cmd/cmdPopup.php",
                true
            );

            var data = new FormData();
            data.append('cmd', _cmd);
            data.append('comment', comment);
            data.append('sticky', sticky);
            data.append('persistent', persistent);
            data.append('notify', notify);
            data.append('ackhostservice', ackhostservice);
            data.append('force_check', force_check);
            data.append('author', author);
            data.append('resources', _getVar);
        }
        else if (_cmd == '74' || _cmd == '75') {
            var downtimehostservice = 0;
            if (document.getElementById('downtimehostservice')) {
                downtimehostservice = document.getElementById('downtimehostservice').checked;
            }
            if (document.getElementById('fixed')) {
                var fixed = document.getElementById('fixed').checked;
            }
            else {
                var fixed = 0;
            }
            var start = jQuery(document).find('[name="alternativeDateStart"]').val() + ' '
                + document.getElementById('start_time').value;
            var end = jQuery(document).find('[name="alternativeDateEnd"]').val() + ' '
                + document.getElementById('end_time').value;
            var author = document.getElementById('author').value;
            var duration = document.getElementById('duration').value;
            var duration_scale = document.getElementById('duration_scale').value;
            var tmp = document.querySelector('input[name="host_or_centreon_time[host_or_centreon_time]"]:checked');
            var host_or_centreon_time = "0";
            if (tmp !== null && typeof tmp !== "undefined") {
                host_or_centreon_time = tmp.value;
            }
            xhr_cmd.open(
                "POST",
                "./include/monitoring/external_cmd/cmdPopup.php",
                true
            );
            var data = new FormData();
            data.append('cmd', _cmd);
            data.append('duration', duration);
            data.append('duration_scale', duration_scale);
            data.append('comment', comment);
            data.append('start', start);
            data.append('end', end);
            data.append('host_or_centreon_time', host_or_centreon_time);
            data.append('fixed', fixed);
            data.append('downtimehostservice', downtimehostservice);
            data.append('author', author);
            data.append('resources', _getVar);
        }
        xhr_cmd.send(data);
        window.currentPopin.centreonPopin("close");
        unsetCheckboxes();
    }

    function toggleFields(fixed) {
        var durationField = jQuery('#duration');
        var durationScaleField = jQuery('#duration_scale');

        if (fixed.checked) {
            durationField.attr('disabled', true);
            durationScaleField.attr('disabled', true);
        } else {
            durationField.removeAttr('disabled');
            durationScaleField.removeAttr('disabled');
        }
    }
</script>
