<?php

/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

/**
 * Description of select2
 *
 * @author Lionel Assepo <lassepo@centreon.com>
 */
class HTML_QuickForm_selectoptgroup extends HTML_QuickForm_select
{
    /** @var string */
    public $_elementHtmlName;

    /** @var string */
    public $_elementTemplate;

    /** @var string */
    public $_elementCSS;

    /** @var string */
    public $_availableDatasetRoute;

    /** @var string */
    public $_defaultDatasetRoute;

    /** @var string */
    public $_defaultDataset = null;

    /** @var bool */
    public $_ajaxSource = false;

    /** @var bool */
    public $_multiple;

    /** @var string */
    public $_multipleHtml = '';

    /** @var string */
    public $_defaultSelectedOptions = '';

    /** @var string */
    public $_jsCallback = '';

    /** @var bool */
    public $_allowClear = true;

    /** @var string */
    public $_linkedObject;

    /** @var type */
    public $_defaultDatasetOptions = [];

    /** @var int The number of element in the pagination */
    public $_pagination;

    /** @var array */
    public $realOptionsArray;

    public $_memOptions = [];

    /**
     * @param string $elementName
     * @param string $elementLabel
     * @param array $options
     * @param array $attributes
     * @param string $sort
     */
    public function __construct(
        $elementName = null,
        $elementLabel = null,
        $options = null,
        $attributes = null,
        $sort = null,
    ) {
        global $centreon;
        $this->realOptionsArray = $options;
        parent::__construct($elementName, $elementLabel, $options, $attributes);
        $this->_elementHtmlName = $this->getName();
        $this->parseCustomAttributes($attributes);

        $this->_pagination = $centreon->optGen['selectPaginationSize'];
    }

    /**
     * @param array $attributes
     */
    public function parseCustomAttributes(&$attributes): void
    {
        // Check for
        if (isset($attributes['datasourceOrigin']) && ($attributes['datasourceOrigin'] == 'ajax')) {
            $this->_ajaxSource = true;
            // Check for
            if (isset($attributes['availableDatasetRoute'])) {
                $this->_availableDatasetRoute = $attributes['availableDatasetRoute'];
            }

            // Check for
            if (isset($attributes['defaultDatasetRoute'])) {
                $this->_defaultDatasetRoute = $attributes['defaultDatasetRoute'];
            }
        }

        if (isset($attributes['multiple']) && $attributes['multiple'] === true) {
            $this->_elementHtmlName .= '[]';
            $this->_multiple = true;
            $this->_multipleHtml = 'multiple="multiple"';
        } else {
            $this->_multiple = false;
        }

        if (isset($attributes['allowClear']) && $attributes['allowClear'] === false) {
            $this->_allowClear = false;
        } elseif (isset($attributes['allowClear']) && $attributes['allowClear'] === true) {
            $this->_allowClear = true;
        }

        if (isset($attributes['defaultDataset']) && ! is_null($attributes['defaultDataset'])) {
            $this->_defaultDataset = $attributes['defaultDataset'];
        }

        if (isset($attributes['defaultDatasetOptions'])) {
            $this->_defaultDatasetOptions = $attributes['defaultDatasetOptions'];
        }

        if (isset($attributes['linkedObject'])) {
            $this->_linkedObject = $attributes['linkedObject'];
        }
    }

    /**
     * @param bool $raw
     * @param bool $min
     * @return string
     */
    public function getElementJs($raw = true, $min = false)
    {
        $jsFile = './include/common/javascript/jquery/plugins/select2/js/';
        $jsFile2 = './include/common/javascript/centreon/centreon-select2-optgroup.js';

        if ($min) {
            $jsFile .= 'select2.min.js';
        } else {
            $jsFile .= 'select2.js';
        }

        return '<script type="text/javascript" '
            . 'src="' . $jsFile . '">'
            . '</script>'
            . '<script type="text/javascript" '
            . 'src="' . $jsFile2 . '">'
            . '</script>';
    }

    /**
     * @return type
     */
    public function getElementHtmlName()
    {
        return $this->_elementHtmlName;
    }

    /**
     * @param bool $raw
     * @param bool $min
     * @return string
     */
    public function getElementCss($raw = true, $min = false)
    {
        $cssFile = './include/common/javascript/jquery/plugins/select2/css/';

        if ($min) {
            $cssFile .= 'select2.min.js';
        } else {
            $cssFile .= 'select2.js';
        }

        return '<link href="' . $cssFile . '" rel="stylesheet" type="text/css"/>';
    }

    /**
     * @return string
     */
    public function toHtml()
    {
        $strHtml = '';
        $readonly = '';
        $strHtml .= '<select id="' . $this->getName()
            . '" name="' . $this->getElementHtmlName()
            . '" ' . $this->_multipleHtml . ' '
            . ' style="width: 300px;" ' . $readonly . '><option></option>'
            . '%%DEFAULT_SELECTED_VALUES%%'
            . '</select>';

        $strHtml .= $this->getJsInit();

        return str_replace('%%DEFAULT_SELECTED_VALUES%%', $this->_defaultSelectedOptions, $strHtml);
    }

    /**
     * @return string
     */
    public function getJsInit()
    {
        $allowClear = 'true';
        $additionnalJs = '';

        if ($this->_allowClear === false || $this->_flagFrozen) {
            $allowClear = 'false';
        }

        $disabled = 'false';
        if ($this->_flagFrozen) {
            $disabled = 'true';
        }

        $ajaxOption = '';
        $defaultData = '';
        if ($this->_ajaxSource) {
            $ajaxOption = 'ajax: {
                url: "' . $this->_availableDatasetRoute . '"
            },';

            if ($this->_defaultDatasetRoute && is_null($this->_defaultDataset)) {
                $additionnalJs = $this->setDefaultAjaxDatas();
            } else {
                $this->setDefaultFixedDatas();
            }
        } else {
            $defaultData = $this->setFixedDatas() . ',';
            $this->setDefaultFixedDatas();
        }

        $additionnalJs .= ' ' . $this->_jsCallback;

        return '<script>
            jQuery(function () {
                var $currentSelect2Object' . $this->getName()
            . ' = jQuery("#' . $this->getName() . '").centreonSelect2({
                    allowClear: ' . $allowClear . ',
                    pageLimit: ' . $this->_pagination . ',
                    optGroup: true,
                    select2: {
                        ' . $ajaxOption . '
                        ' . $defaultData . '
                        placeholder: "' . $this->getLabel() . '",
                        disabled: ' . $disabled . '
                    }
                });
                
                ' . $additionnalJs . '
            });
         </script>';
    }

    /**
     * @return string
     */
    public function setFixedDatas()
    {
        $datas = 'data: ';
        $datas .= json_encode($this->realOptionsArray, 1);

        return $datas;
    }

    /**
     * obsolete
     */
    public function setDefaultFixedDatas()
    {
        return true;
    }

    /**
     * @param string $event
     * @param string $callback
     */
    public function addJsCallback($event, $callback): void
    {
        $this->_jsCallback .= ' jQuery("#' . $this->getName() . '").on("' . $event . '", function(){ '
            . $callback
            . ' }); ';
    }

    /**
     * @return string
     */
    public function setDefaultAjaxDatas()
    {
        return '$request' . $this->getName() . ' = jQuery.ajax({
            url: "' . $this->_defaultDatasetRoute . '",
        });
        
        $request' . $this->getName() . '.success(function (data) {
            for (var d = 0; d < data.length; d++) {
                var item = data[d];
                
                // Create the DOM option that is pre-selected by default
                var option = "<option selected=\"selected\" value=\"" + item.id + "\" ";
                if (item.hide === true) {
                    option += "hidden";
                }
                option += ">" + item.text + "</option>";
              
                // Append it to the select
                $currentSelect2Object' . $this->getName() . '.append(option);
            }
 
            // Update the selected options that are displayed
            $currentSelect2Object' . $this->getName() . '.trigger("change",[{origin:\'select2defaultinit\'}]);
        });

        $request' . $this->getName() . '.error(function(data) {
            
        });
        ';
    }

    /**
     * @return string
     */
    public function getFrozenHtml()
    {
        return '';
    }

    /**
     * @param type $event
     * @param type $arg
     * @param type $caller
     * @return bool
     */
    public function onQuickFormEvent($event, $arg, &$caller)
    {
        if ($event == 'updateValue') {
            $value = $this->_findValue($caller->_constantValues);

            if ($value === null) {
                $value = is_null($this->_defaultDataset) ? $this->_findValue($caller->_submitValues) : $this->_defaultDataset;

                // Fix for bug #4465 & #5269
                // XXX: should we push this to element::onQuickFormEvent()?
                if ($value === null && (! $caller->isSubmitted() || ! $this->getMultiple())) {
                    $value = $this->_findValue($caller->_defaultValues);
                }
            }

            if ($value !== null) {
                if (! is_array($value)) {
                    $value = [$value];
                }
                $this->_defaultDataset = $value;
                $this->setDefaultFixedDatas();
            }

            return true;
        }

        return parent::onQuickFormEvent($event, $arg, $caller);
    }
}

if (class_exists('HTML_QuickForm')) {
    (new HTML_QuickForm())->registerElementType(
        'selectoptgroup',
        'HTML/QuickForm/selectoptgroup.php',
        'HTML_QuickForm_selectoptgroup'
    );
}
