<?php

/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

declare(strict_types=1);

namespace Centreon\Infrastructure\MonitoringServer\API\Model;

/**
 * This class is designed to represent the formatted response of the API request.
 *
 * @package Centreon\Infrastructure\MonitoringServer\API\Model
 */
class RealTimeMonitoringServer
{
    /** @var int */
    public $id;

    /** @var string */
    public $name;

    /** @var string|null */
    public $address;

    /** @var bool */
    public $isRunning;

    /** @var int|null */
    public $lastAlive;

    /** @var string|null */
    public $version;

    /** @var string|null */
    public $description;
}
