<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>{{ config('api-platform.title') }} - API Platform</title>
        <link rel="stylesheet" href="/vendor/api-platform/fonts/open-sans/400.css">
        <link rel="stylesheet" href="/vendor/api-platform/fonts/open-sans/700.css">
        <link rel="stylesheet" href="/vendor/api-platform/swagger-ui/swagger-ui.css">
        <link rel="stylesheet" href="/vendor/api-platform/style.css">
        <style>body { margin: 0; }</style>
        <script id="swagger-data" type="application/json">{!! Illuminate\Support\Js::encode($swagger_data) !!}</script>
    </head>
    <body>
        <header>
            <a id="logo" href="https://api-platform.com/"><img src="/vendor/api-platform/logo-header.svg" alt="API Platform"></a>
        </header>
        @if (config('api-platform.show_webby', true))
        <div class="web calm"><img src="/vendor/api-platform/web.png"></div>
        <svg class="webby_car" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1889.21 582.3">
            <g id="Calque_1">
                <g id="Fumée" class="smoke">
                    <path
                        d="m609.07,574.45c-59.15-3.88-178.39-19.63-247.1-28.9-30.92-4.17-65.17-10.99-94.53-21.54-29.36-10.55-56.69-30.83-68.46-59.72-7.9-19.38-7.42-43.7,6.78-59.06,17.03-18.41,46.25-17.68,70.69-12.03-15.92-15.72-39.89-22.81-61.8-18.28-21.91,4.54-41.1,20.57-49.46,41.32-22.82-11.61-52.45-8.16-71.99,8.38-19.54,16.54-27.83,45.2-20.15,69.62-18.8-6.88-41.21-2.64-56.21,10.62-14.99,13.26-19.72,50.09-15.19,69.59h607.43Z"
                        fill="#cfcece" stroke-width="0" />
                </g>
                <path
                    d="m137.94,302.39c0,.44,30.31.79,67.69.79,37.39,0,67.69-.35,67.69-.79s-30.3-.79-67.69-.79c-37.38,0-67.69.35-67.69.79Z"
                    fill="#192e35" stroke-width="0" />
                <path
                    d="m1384.27,259.62v-66.08h-437.89c-65.42.08-105.3-9.84-156.11-33.67-54.88-24.94-131.63-6.59-186.3,11.51v88.25h780.3Z"
                    fill="#0b1623" fill-rule="evenodd" stroke-width="0" />
                <ellipse cx="1231.71" cy="360.38" rx="31.72" ry="8.59" transform="translate(-38.74 178.89) rotate(-8.18)"
                    fill="#1e1f1d" opacity=".2" stroke-width="0" />
                <polygon
                    points="1194.2 331.94 1199.27 343.28 1234.06 103.4 1131.46 164.51 1138.76 168.8 1225.77 116.22 1194.2 331.94"
                    fill="#1e1f1d" stroke-width="0" />
                <polygon
                    points="1119.11 376.71 1194.66 190.68 1109.8 205.91 1108.02 213.29 1180.52 201.65 1109.08 377.91 1119.11 376.71"
                    fill="#1e1f1d" stroke-width="0" />
                <polyline points="1062.88 156.6 1076.6 265.85 1084.78 263.59 1072.16 147.94" fill="#1e1f1d" stroke-width="0" />
                <path
                    d="m1084.98,262.46s6.88-17.81,18.49-8.78c11.61,9.04,7.84,24.37,7.84,24.37,0,0-2.66,4.97-13.84,7.09s-13.9,2-16.52-1.2c-2.61-3.19-4.53-18.98-4.53-18.98l8.56-2.5Z"
                    fill="#1e1f1d" stroke-width="0" />
                <path
                    d="m1198.84,341.94c-2.24,4.84,16.18-25.8,31.46-15.71,18.52,12.24,11.91,33.76,11.91,33.76,0,0-4.67,5.7-22.96,8.36-23.8,3.45-22.92-3.06-25.48-8.95-4.29-9.88,1.35-32.69,1.35-32.69l3.73,15.22Z"
                    fill="#1e1f1d" stroke-width="0" />
                <path
                    d="m1168.59,278.49s2.1-15.95,14.35-7.79c7.28,4.85,8.69,11.87,8.64,16.77-.04,3.93-2.45,7.42-6.11,8.83-2.29.88-5.44,1.97-9.8,2.41-15.89,1.58-14.43-3.71-14.81-6-2.2-13.29,1.63-22.12,1.63-22.12l6.1,7.9Z"
                    fill="#1e1f1d" stroke-width="0" />
                <path
                    d="m1119.05,375.54s10.41-26,29.33-13.82c18.92,12.18,9.27,32.8,9.27,32.8,0,0-4.66,6.72-23.39,9.44-24.38,3.54-28.32-8.57-27.47-15.02,2.97-22.38,8.4-13.19,8.09-13.63l4.17.23Z"
                    fill="#1e1f1d" stroke-width="0" />
                <polyline points="1140.7 141.58 1186.27 200.31 1256.87 155.77" fill="none" fill-rule="evenodd" stroke="#010101"
                    stroke-miterlimit="10" stroke-width="8.04" />
                <polygon points="945.86 364.96 939.7 373.92 880.71 269 992.01 221.94 1001.36 231.27 895.46 273.17 945.86 364.96"
                    fill="#1e1f1d" stroke-width="0" />
                <polygon
                    points="1052.2 389 1010.3 251.89 1059.75 222.45 1063.91 231.64 1021.55 257.88 1060.85 387.51 1052.2 389"
                    fill="#1e1f1d" stroke-width="0" />
                <polyline points="996.72 174.53 1013.56 279.02 1005.84 283.36 985.38 168.83" fill="#1e1f1d" stroke-width="0" />
                <path
                    d="m1005.33,282.33s-10.31-15.34-18.9-3.4c-8.59,11.94-.66,25.59-.66,25.59,0,0,3.96,4.02,15.27,2.9,11.32-1.12,13.9-2,15.51-5.8,1.61-3.8-4.42-29.17-4.42-29.17l-6.8,9.88Z"
                    fill="#1e1f1d" stroke-width="0" />
                <path
                    d="m938.42,372.69s-17.85-24.85-32.18-7.89c-8.1,9.59-7.66,19.76-5.74,26.79,1.73,6.35,7.39,10.89,13.96,11.28,3.59.21,8.26.08,14.24-.77,23.81-3.39,22.07-12.2,22.86-18.56,1.34-10.68-6.45-20.01-6.45-20.01l-6.69,9.17Z"
                    fill="#1e1f1d" stroke-width="0" />
                <path
                    d="m1049.68,381.5s-15.81-20.9-30.54-3.88c-14.73,17.02-2.09,35.77-2.09,35.77,0,0,6.36,5.14,25.1,2.47,24.39-3.47,23.98-15.91,22.12-22.15-7.77-26.17-11.42-18.84-11.42-18.84l-3.18,6.63Z"
                    fill="#1e1f1d" stroke-width="0" />
                <path
                    d="m954.08,153.03c10.67,74.26,41.81,88.1,108.2,78.56,52.44-7.54,87.72-45.17,79.05-105.47s-51.53-75.49-103.97-67.95c-52.44,7.54-91.95,34.56-83.28,94.87Z"
                    fill="#3baab4" stroke-width="0" />
                <path
                    d="m986.4,227.85c-21.78-14.64-31.1-44.27-35.43-74.37-7.99-55.6,22.9-91.29,86.98-100.5,63.27-9.09,101,15.91,109.11,72.31,4.34,30.22-1.76,56.71-17.65,76.6-14.85,18.59-37.36,30.52-65.09,34.51-27.52,3.95-58.07,4.78-77.91-8.55Zm-26.6-75.64c9.62,66.93,34.12,84.11,103.07,74.2,54.21-7.79,83.08-46.05,75.35-99.84-7.27-50.58-40.52-71.97-98.84-63.59-41.3,5.94-88.63,26.24-79.58,89.23Z"
                    fill="#1e1f1d" stroke-width="0" />
                <path
                    d="m1062.26,94.26c22.23,28.28,52.8,40.56,69.62,27.34,16.82-13.22,12.43-46.86-9.79-75.14-22.23-28.28-53.88-40.5-70.7-27.28-16.82,13.22-11.36,46.8,10.87,75.08Z"
                    fill="#fff" stroke-width="0" />
                <path
                    d="m1061.46,95.73c18.77,23.89,43.09,36.79,61.28,34.18,4.8-.69,9.16-2.46,12.89-5.39,8.74-6.86,12.46-19,10.5-34.18-1.95-15.05-9.27-31.29-20.62-45.73-11.35-14.44-25.39-25.39-39.56-30.85-14.28-5.5-26.95-4.75-35.69,2.12-17.57,13.81-12.55,49.63,11.2,79.85Zm4.22-3.32c-10.2-12.98-16.93-27.43-18.95-40.68-2.02-13.26.97-23.79,8.41-29.64,3.14-2.46,6.88-4,11.09-4.61,5.86-.84,12.62.13,19.87,2.93,12.57,4.86,25.07,14.63,35.19,27.51,20.84,26.53,25.09,58.1,9.46,70.38-15.5,12.18-44.08.81-65.07-25.9Z"
                    fill="#010101" stroke-width="0" />
                <ellipse cx="1097.78" cy="48.22" rx="13.47" ry="29.01" transform="translate(204.84 688.61) rotate(-38.16)"
                    fill="#1e1f1d" stroke-width="0" />
                <ellipse cx="1087.2" cy="35.33" rx="5.93" ry="7.99" transform="translate(197.27 660.86) rotate(-36.96)"
                    fill="#fff" stroke-width="0" />
                <ellipse cx="1065.39" cy="99.84" rx="33.39" ry="54.72" transform="translate(166.02 679.63) rotate(-38.16)"
                    fill="#fff" stroke-width="0" />
                <path
                    d="m1038.26,122c15.82,20.13,37.25,31.08,53.29,28.77,4.31-.62,8.23-2.19,11.55-4.8,7.63-6,10.98-16.49,9.43-29.53-1.54-12.93-7.72-26.83-17.39-39.13-9.67-12.31-21.72-21.59-33.91-26.15-12.31-4.6-23.29-3.82-30.93,2.18-15.68,12.32-12.11,43.13,7.96,68.67Zm-10.64-37.21c-1.3-11.03,1.49-19.86,7.86-24.86,2.78-2.18,6.06-3.5,9.66-4.02,13.65-1.96,32.01,7.5,45.63,24.82,8.36,10.64,13.69,22.63,15,33.78,1.3,11.03-1.49,19.86-7.86,24.86-2.78,2.18-6.06,3.5-9.66,4.02-13.65,1.96-32.01-7.5-45.63-24.82-8.36-10.64-13.69-22.63-15-33.78Z"
                    fill="#010101" stroke-width="0" />
                <ellipse cx="1070.76" cy="81.09" rx="12.29" ry="24.22" transform="translate(178.75 678.94) rotate(-38.16)"
                    fill="#1e1f1d" stroke-width="0" />
                <ellipse cx="1063.08" cy="72.67" rx="5.16" ry="6.95" transform="translate(197.82 694.56) rotate(-39.62)"
                    fill="#fff" stroke-width="0" />
                <ellipse cx="1143.99" cy="395.68" rx="35.02" ry="11.23" transform="translate(-44.66 166.77) rotate(-8.18)"
                    fill="#1e1f1d" opacity=".2" stroke-width="0" />
                <ellipse cx="1180.82" cy="289.59" rx="20.48" ry="9.25" transform="translate(-29.19 170.93) rotate(-8.18)"
                    fill="#1e1f1d" opacity=".2" stroke-width="0" />
                <ellipse cx="1101.56" cy="276.95" rx="23.13" ry="9.25" transform="translate(-28.2 159.53) rotate(-8.18)"
                    fill="#1e1f1d" opacity=".2" stroke-width="0" />
                <ellipse cx="916.64" cy="397.65" rx="31.72" ry="8.59" transform="translate(-47.25 134.45) rotate(-8.18)"
                    fill="#1e1f1d" opacity=".2" stroke-width="0" />
                <ellipse cx="1028.7" cy="410.92" rx="35.02" ry="11.23" transform="translate(-48 150.52) rotate(-8.18)"
                    fill="#1e1f1d" opacity=".2" stroke-width="0" />
                <ellipse cx="916.39" cy="326.26" rx="20.48" ry="9.25" transform="translate(-37.09 133.69) rotate(-8.18)"
                    fill="#1e1f1d" opacity=".2" stroke-width="0" />
                <ellipse cx="994.31" cy="301.71" rx="23.13" ry="9.25" transform="translate(-32.81 144.52) rotate(-8.18)"
                    fill="#1e1f1d" opacity=".2" stroke-width="0" />
                <path
                    d="m1481.7,222.32c-106.1-78.12-225.29-160.42-329.57-218.14-7.36-4.1-14.79-2.88-19.14,3.5l-16.81,24.89c-6.24,9.36-3.27,18.4,5.85,24.46,75.23,50.08,139.88,97.4,209.18,165.29h150.49Z"
                    fill="#a9d7e4" fill-rule="evenodd" stroke-width="0" />
                <path
                    d="m1160.91,9.08l-14.49,21.28c-3.88,5.96-2.15,12.32,3.56,16.22,27.86,18.53,59.47,40.91,91.01,65.37,43.62,33.81,87.17,71.72,120.64,109.2.34.38.64.77.92,1.17h-31.34c-67.43-66.06-130.46-112.65-203.11-161.24l-2.55-1.86-3.52-2.19c-9.12-6.06-12.09-15.1-5.85-24.46l3.7-5.47,13.11-19.42c4.35-6.38,11.78-7.59,19.14-3.5l8.78,4.9Z"
                    fill="#d83715" fill-rule="evenodd" stroke-width="0" />
                <rect x="490.65" y="298.38" width="331.62" height="170.97" fill="#010101" stroke-width="0" />
                <rect x="1410.09" y="298.38" width="331.62" height="170.97" fill="#010101" stroke-width="0" />
                <path
                    d="m327.66,334.94l6.55,56.4c.73,7.25-.94,10.32-4.38,13.86l-3.85,4.18c-4.5,4.46-7.29,11.19-6.32,20.21l3.09,27.09c1.68,10.77,8.4,15.94,20.97,17.08l144.43,8.87c13.4,1.64,19.85-4.46,19.15-18.21-2.88-42.85,12.72-85.32,43.64-116.24,27.15-27.15,64.68-43.96,106.1-43.96,41.44,0,78.95,16.8,106.11,43.96,31.07,31.07,46.66,73.81,43.58,116.87-.71,11.62,4.54,18.95,17.92,18.73,148.87,0,437.51,0,586.38,0,12.09.14,16.56-6.39,15.81-18.64-3.12-43.24,12.47-85.89,43.57-116.97,27.15-27.15,64.68-43.95,106.11-43.95,41.43,0,78.94,16.8,106.1,43.96,31.07,31.07,46.7,73.86,43.58,116.96-.77,12.2,4.62,18.65,14.96,18.78l117.63-7.38c14.91-1.87,22.35-6.07,27.12-15.51v-74.45c-.37-16.93-.55-25.03-11.57-38.77-17.05-20.02-43.71-33.93-70.2-49.18-13.29-7.65-23.23-14.64-35.57-23.68-78.37-57.16-140.8-40.04-274.42-61.7-20.63-3.34-35.32-5.33-56.88-5.25h-490.89c-190.36-.53-279.19-21.96-330.39-48.51-16.74-8.5-28.57-10.16-44.46-6.42-103.57,26.26-189.39,86.74-225.85,128.46-15.03,16.9-19.95,31.38-18.02,53.41Z"
                    fill="#d83715" fill-rule="evenodd" stroke-width="0" />
                <path
                    d="m656.47,340.33c-65.46,0-118.55,53.08-118.55,118.55s53.09,118.55,118.55,118.55,118.55-53.08,118.55-118.55-53.08-118.55-118.55-118.55Z"
                    fill="#1f2631" fill-rule="evenodd" stroke-width="0" />
                <path
                    d="m1575.9,340.33c-65.47,0-118.55,53.08-118.55,118.55s53.08,118.55,118.55,118.55,118.54-53.08,118.54-118.55-53.07-118.55-118.54-118.55Z"
                    fill="#1f2631" fill-rule="evenodd" stroke-width="0" />
                <path
                    d="m1726.16,443c.55,7.34.57,14.74.03,22.14-.77,12.2,4.62,18.65,14.96,18.78l117.63-7.38c14.91-1.87,22.35-6.07,27.12-15.51v-18.03h-159.74Zm-919.48,0c.55,7.3.58,14.67.05,22.06-.71,11.62,4.54,18.95,17.92,18.73,148.87,0,437.51,0,586.38,0,12.09.14,16.56-6.39,15.81-18.64-.53-7.42-.52-14.82.03-22.15h-620.19Zm-386.84-93.01h-90.42l4.79,41.35c.73,7.25-.94,10.32-4.38,13.86l-3.85,4.18c-4.5,4.46-7.29,11.19-6.32,20.21l3.09,27.09c1.68,10.77,8.4,15.94,20.97,17.08l144.43,8.87c13.4,1.64,19.85-4.46,19.15-18.21-1.49-22.12,1.95-44.15,9.87-64.52l-47.03-34.37c-16.29-12.18-31.93-15.8-50.31-15.54Z"
                    fill="#af2517" fill-rule="evenodd" stroke-width="0" />
                <path
                    d="m1760.33,269.18h-828.49c-245.67,0-389.03,8.6-602.2,39.27,2.73-9.31,7.9-17.76,16.04-26.92,36.45-41.71,122.28-102.19,225.85-128.46,15.89-3.75,27.72-2.08,44.46,6.42,51.2,26.55,140.03,47.97,330.39,48.51h490.89c21.56-.08,36.25,1.9,56.88,5.25,128.9,20.89,191.55,5.72,266.18,55.93Z"
                    fill="#c2371f" fill-rule="evenodd" stroke-width="0" />
                <path
                    d="m348.49,278.38c32.05,6.25,69.21,12.49,103.94,17.22,4.95,1,5.17,5.3,2.66,7.86l-12.84,11.82c-6.6,5.82-11.74,8.02-22.66,8.16l-92.28.03c.57-15.97,6.1-28.15,18.37-41.93.91-1.04,1.84-2.09,2.81-3.15Z"
                    fill="#e73331" fill-rule="evenodd" stroke-width="0" />
                <path
                    d="m901.09,226.82c-162.78-3.27-242.49-23.46-289.92-48.06-16.74-8.49-28.57-10.16-44.46-6.42-103.57,26.26-189.39,86.75-225.85,128.46-6.01,6.76-10.4,13.13-13.39,19.74,1.12-14.57,6.7-26.08,18.21-39.02,36.45-41.71,122.28-102.19,225.85-128.46,15.89-3.75,27.72-2.08,44.46,6.42,51.2,26.55,140.03,47.97,330.39,48.51h490.89c21.56-.08,36.25,1.9,56.88,5.25,133.61,21.66,196.04,4.54,274.42,61.7,12.35,9.04,22.28,16.03,35.57,23.68,26.49,15.25,53.15,29.17,70.2,49.18,11.01,13.74,11.19,21.84,11.57,38.77v5.23c-1.28-6.87-4.03-12.89-10.33-20.74-17.05-20.02-49.77-37.92-76.25-53.17-13.29-7.65-23.23-14.65-35.57-23.68-78.37-57.16-140.8-40.04-274.42-61.7-20.63-3.35-35.32-5.33-56.88-5.25h-64.96"
                    fill="#e73331" fill-rule="evenodd" stroke="#010101" stroke-miterlimit="10" stroke-width="4" />
                <path
                    d="m1712.36,263.01c32.95-2.82,60.29,27.42,71.03,52.29,2.74,6.35,2.5,12.78-6.55,10.73-25.16-5.69-59.29-29-69.82-49.65-2.93-5.76-2.88-12.66,5.34-13.37Z"
                    fill="#c0baaa" fill-rule="evenodd" stroke-width="0" />
                <path
                    d="m1712.36,263.01c28.14-2.41,52.19,19.29,65.3,41.17-4.5-3.11-9.02-6.37-13.91-9.96-19.01-13.86-37.07-23.34-55.44-30.08,1.04-.6,2.37-.99,4.05-1.14Z"
                    fill="#fff" fill-rule="evenodd" stroke-width="0" />
                <rect x="921.95" y="284.11" width="76.5" height="14.46" fill="#af2517" stroke="#010101" stroke-miterlimit="10"
                    stroke-width="4" />
                <path
                    d="m924.25,207.83l-10.99,11.63c-8.98,9.52-14.25,19.25-16.63,29.71-2.4,10.58-1.9,22.03.67,34.82h.01s17.68,89.8,17.68,89.8h-.01c3.23,15.63,7.78,29.18,15.86,38.66,7.88,9.23,19.4,14.72,36.78,14.65l.02-.02h393.37v.02h.11s.03,0,.03,0c6.11-.1,10.26-1.84,12.78-4.74v-.02c2.57-2.95,3.67-7.29,3.62-12.45v-.21s-.02-.07-.02-.07v-124.31c.38-18.07-2.08-32.21-8.74-45.31-5.46-10.73-13.77-20.87-25.68-32h10.36c9.71,9.73,16.79,18.96,21.76,28.72,7.22,14.21,9.9,29.38,9.52,48.66h.02s0,124.24,0,124.24h-.02v.13s0,.04,0,.04c.07,6.92-1.56,12.91-5.38,17.29h0c-3.86,4.43-9.75,7.08-18.08,7.21h-.2s-.09.02-.09.02h-393.37,0c-19.78.07-33.03-6.36-42.27-17.18-9.03-10.57-13.99-25.21-17.45-41.93v-.03s-17.69-89.79-17.69-89.79h.01c-2.77-13.76-3.27-26.18-.64-37.8,2.67-11.74,8.51-22.58,18.4-33.07l6.44-6.82,9.8.14Z"
                    fill="#972614" fill-rule="evenodd" stroke-width="0" />
                <path
                    d="m1317.51,209.26c-1.26-1.19-2.53-2.39-3.79-3.58-.9-.84-1.79-1.67-2.69-2.51-1.22-1.13-2.44-2.27-3.65-3.4-.91-.84-1.81-1.66-2.71-2.49-1.21-1.11-2.41-2.22-3.62-3.31-.91-.82-1.81-1.64-2.71-2.46-1.2-1.09-2.4-2.18-3.6-3.25-.9-.8-1.79-1.6-2.69-2.4-1.21-1.08-2.42-2.16-3.63-3.22-.89-.78-1.77-1.56-2.66-2.34-1.21-1.07-2.43-2.13-3.64-3.19-.88-.77-1.76-1.52-2.64-2.28-1.22-1.06-2.45-2.12-3.67-3.17-.87-.74-1.73-1.48-2.6-2.22-1.23-1.05-2.47-2.11-3.7-3.15-.86-.72-1.71-1.44-2.57-2.16-1.25-1.05-2.5-2.1-3.75-3.14-.84-.7-1.67-1.39-2.51-2.08-1.27-1.05-2.54-2.11-3.81-3.15-.82-.67-1.63-1.34-2.45-2.01-1.29-1.06-2.58-2.11-3.88-3.16-.8-.65-1.6-1.3-2.41-1.94-1.31-1.06-2.62-2.11-3.93-3.16-.78-.62-1.56-1.25-2.35-1.87-1.34-1.07-2.68-2.13-4.02-3.19-.75-.59-1.51-1.19-2.26-1.78-1.37-1.08-2.74-2.15-4.12-3.22-.73-.57-1.46-1.13-2.19-1.7-1.4-1.09-2.8-2.17-4.21-3.25-.71-.54-1.42-1.09-2.12-1.63-1.43-1.1-2.87-2.19-4.31-3.28-.68-.52-1.36-1.03-2.04-1.54-1.47-1.11-2.95-2.22-4.42-3.33-.65-.49-1.3-.98-1.96-1.46-1.51-1.13-3.02-2.25-4.54-3.37-.62-.46-1.24-.92-1.86-1.38-1.56-1.15-3.12-2.3-4.69-3.44-.58-.42-1.16-.85-1.74-1.27-1.6-1.17-3.21-2.34-4.82-3.5-.55-.4-1.1-.8-1.66-1.2-1.65-1.19-3.31-2.38-4.97-3.57-.51-.37-1.02-.73-1.53-1.1-1.71-1.22-3.42-2.43-5.13-3.65-.47-.33-.94-.67-1.42-1-1.77-1.25-3.54-2.5-5.32-3.74-.42-.29-.84-.59-1.26-.88-1.82-1.27-3.65-2.55-5.47-3.82-.39-.27-.79-.55-1.18-.82-1.88-1.31-3.77-2.61-5.66-3.91-.34-.23-.68-.47-1.02-.7-1.93-1.33-3.86-2.65-5.8-3.98-.32-.22-.64-.44-.96-.66-1.99-1.36-3.98-2.71-5.98-4.07-.27-.18-.54-.37-.82-.55-2.03-1.37-4.06-2.75-6.1-4.12-.26-.18-.52-.35-.78-.53-2.02-1.36-4.06-2.73-6.1-4.1-.29-.19-.57-.38-.86-.58-2.28-1.53-4.57-3.06-6.88-4.59-9.12-6.06-12.09-15.1-5.85-24.46l3.7-5.47,13.11-19.42c4.35-6.38,11.78-7.59,19.14-3.5l8.78,4.9h0c102.16,57.42,192.72,122.75,295.86,198.69"
                    fill="none" fill-rule="evenodd" stroke="#010101" stroke-miterlimit="10" stroke-width="7" />
                <path
                    d="m325.79,409.43l3.85-4.18c3.44-3.55,5.12-6.62,4.38-13.86l-6.55-56.4c-.89-10.1-.33-18.61,1.98-26.49,0,0,0,0,0,0,.01-.04.03-.09.04-.13.14-.49.29-.97.45-1.45.02-.07.05-.14.07-.21,1.13-3.42,2.61-6.74,4.45-10.04.02-.04.05-.08.07-.12.28-.5.57-.99.86-1.49.05-.08.1-.17.15-.25.27-.45.55-.9.84-1.35.07-.11.14-.23.22-.34.27-.42.55-.84.83-1.27.09-.13.18-.27.27-.4.27-.4.55-.8.84-1.2.11-.15.21-.3.32-.45.28-.39.56-.77.85-1.16.12-.16.24-.32.36-.48.29-.38.58-.76.88-1.15.13-.16.26-.33.39-.49.3-.38.62-.77.93-1.15.13-.16.26-.33.4-.49.33-.4.68-.81,1.02-1.22.12-.14.24-.29.37-.43.47-.55.95-1.1,1.44-1.65,36.45-41.71,122.28-102.19,225.85-128.46,15.89-3.75,27.72-2.08,44.46,6.42,51.2,26.55,140.03,47.97,330.39,48.51h490.89c21.56-.08,36.25,1.9,56.88,5.25,2.05.33,4.07.65,6.09.97.84.13,1.68.26,2.52.38,1.16.18,2.32.36,3.47.53.94.14,1.87.28,2.81.41,1.04.15,2.08.31,3.1.46.96.14,1.91.27,2.86.41.98.14,1.97.28,2.94.41.98.14,1.95.27,2.92.4.93.13,1.87.25,2.79.38.97.13,1.92.25,2.88.38.92.12,1.84.24,2.75.36.94.12,1.88.24,2.82.35.91.11,1.82.23,2.73.34.93.11,1.86.23,2.78.34.89.11,1.78.21,2.67.32.91.11,1.81.21,2.71.32.89.1,1.79.21,2.68.31.87.1,1.74.2,2.61.29.9.1,1.81.2,2.71.3.83.09,1.66.18,2.49.27.92.1,1.85.2,2.76.29.78.08,1.55.16,2.32.24.97.1,1.94.2,2.9.3.71.07,1.41.14,2.12.21,1.01.1,2.01.2,3.01.3.65.06,1.29.13,1.94.19,1.07.1,2.14.21,3.2.31.53.05,1.06.1,1.59.15,1.19.11,2.37.22,3.54.33.39.04.79.07,1.18.11,1.37.13,2.73.25,4.08.37.15.01.3.03.45.04,41.11,3.71,74.42,5.77,105.41,13.28,0,0,0,0,0,0,1.17.28,2.34.57,3.5.87,0,0,.02,0,.03,0,1.16.3,2.31.6,3.47.92.01,0,.02,0,.04,0,1.15.32,2.31.64,3.46.97,0,0,0,0,0,0,18.51,5.36,36.4,13.03,54.87,24.57.01,0,.02.01.03.02,1.07.67,2.14,1.35,3.21,2.04.11.07.22.14.33.21,1,.65,1.99,1.31,2.99,1.98.14.09.28.18.42.28h0c2.73,1.84,5.47,3.75,8.24,5.77,12.35,9.04,22.28,16.03,35.57,23.68,26.49,15.25,53.15,29.17,70.2,49.18,11.01,13.74,11.19,21.84,11.57,38.77v56.42s0,18.03,0,18.03c-4.77,9.45-12.21,13.64-27.12,15.51l-117.63,7.38c-10.34-.13-15.73-6.58-14.96-18.78.12-1.66.2-3.33.27-4.99.02-.46.03-.92.04-1.38.04-1.29.06-2.58.07-3.88,0-.42,0-.84,0-1.26,0-1.63-.04-3.27-.1-4.9-.01-.35-.04-.7-.05-1.04-.06-1.3-.13-2.59-.22-3.89-2.5-35.61-17.67-69.7-43.59-95.63-27.16-27.15-64.67-43.96-106.1-43.96-41.43,0-78.95,16.8-106.11,43.95-25.94,25.92-41.08,59.89-43.58,95.54-.1,1.38-.18,2.77-.23,4.16-.01.27-.03.54-.04.81-.06,1.66-.09,3.32-.1,4.98,0,.39,0,.78,0,1.16,0,1.32.03,2.65.07,3.98.01.44.03.88.04,1.32.06,1.67.15,3.34.27,5.02.75,12.26-3.72,18.78-15.81,18.64-148.87,0-437.51,0-586.38,0-13.38.22-18.63-7.11-17.92-18.73.12-1.67.2-3.35.26-5.02.02-.41.03-.83.04-1.24.04-1.39.06-2.79.07-4.18,0-.3,0-.6,0-.9,0-1.73-.04-3.47-.11-5.19,0-.05,0-.1,0-.14-.07-1.66-.16-3.31-.29-4.96-2.59-35.47-17.7-69.38-43.55-95.23-27.16-27.15-64.67-43.96-106.11-43.96-41.42,0-78.95,16.8-106.1,43.96-15.26,15.26-26.78,33.34-34.2,52.89-.19.5-.38,1-.56,1.5-.28.76-.55,1.53-.82,2.3-.17.49-.34.99-.51,1.48-.26.78-.52,1.56-.77,2.34-.16.49-.31.98-.46,1.48-.24.79-.48,1.58-.71,2.37-.14.49-.28.99-.42,1.49-.22.79-.44,1.59-.65,2.39-.13.5-.25,1-.38,1.5-.2.8-.4,1.6-.58,2.4-.12.5-.23,1.01-.34,1.52-.18.8-.35,1.6-.52,2.41-.11.51-.2,1.03-.3,1.54-.15.8-.31,1.6-.45,2.4-.09.53-.18,1.05-.27,1.58-.13.79-.26,1.59-.38,2.38-.08.54-.15,1.08-.23,1.62-.11.79-.22,1.57-.32,2.36-.07.56-.13,1.12-.19,1.67-.09.77-.17,1.55-.25,2.33-.06.58-.1,1.16-.15,1.74-.06.76-.13,1.52-.18,2.28-.04.6-.07,1.21-.1,1.81-.04.74-.09,1.48-.12,2.22-.03.63-.04,1.27-.06,1.9-.02.72-.05,1.43-.06,2.15,0,.68,0,1.37,0,2.05,0,.67,0,1.34,0,2.01.01.78.04,1.56.06,2.35.02.57.02,1.15.05,1.72.05,1.36.13,2.71.22,4.07.71,13.75-5.74,19.85-19.15,18.21l-144.43-8.87c-12.57-1.15-19.29-6.31-20.97-17.08l-3.09-27.09c-.97-9.01,1.82-15.74,6.32-20.21Z"
                    fill="none" fill-rule="evenodd" stroke="#010101" stroke-miterlimit="10" stroke-width="7" />
                <path
                    d="m1109.93,329.13v48.69h17.74v8.4h-27.19v-57.08h9.45Zm51.09,24.22v-5.13h8.95v38h-8.95v-5.14c-1.2,1.9-2.92,3.4-5.13,4.49-2.22,1.09-4.45,1.63-6.69,1.63-2.9,0-5.56-.53-7.97-1.59-2.34-1.01-4.46-2.5-6.2-4.36-1.73-1.85-3.09-4.01-4.02-6.36-.97-2.44-1.46-5.04-1.44-7.67,0-2.66.48-5.2,1.44-7.63.93-2.37,2.29-4.54,4.02-6.4,1.75-1.86,3.86-3.35,6.2-4.36,2.41-1.06,5.06-1.59,7.97-1.59,2.24,0,4.48.55,6.69,1.63,2.22,1.09,3.93,2.58,5.13,4.48Zm-.82,18.51c.55-1.49.83-3.06.82-4.65,0-1.63-.28-3.18-.82-4.65-.51-1.41-1.29-2.71-2.3-3.83-1-1.1-2.22-1.99-3.57-2.61-1.4-.65-2.94-.98-4.64-.98s-3.23.33-4.6.98c-1.37.65-2.55,1.52-3.53,2.61-1,1.11-1.77,2.42-2.26,3.83-.53,1.49-.79,3.07-.78,4.65,0,1.63.26,3.18.78,4.65.49,1.42,1.26,2.72,2.26,3.83.99,1.09,2.19,1.98,3.53,2.61,1.37.65,2.9.98,4.6.98s3.25-.32,4.64-.98c1.35-.62,2.57-1.51,3.57-2.61,1-1.12,1.78-2.42,2.3-3.83Zm16.84,14.35v-38h24.31v8.75h-15.36s0,29.25,0,29.25h-8.95Zm56.75-32.86v-5.13h8.95v38h-8.95v-5.14c-1.21,1.9-2.92,3.4-5.13,4.49-2.22,1.09-4.45,1.63-6.69,1.63-2.9,0-5.56-.53-7.97-1.59-2.34-1.01-4.46-2.5-6.2-4.36-1.73-1.85-3.09-4.01-4.02-6.36-.97-2.44-1.46-5.04-1.44-7.67,0-2.66.48-5.2,1.44-7.63.93-2.37,2.29-4.54,4.02-6.4,1.75-1.86,3.86-3.35,6.2-4.36,2.41-1.06,5.06-1.59,7.97-1.59,2.24,0,4.48.55,6.69,1.63,2.22,1.09,3.93,2.58,5.13,4.48Zm-.82,18.51c.55-1.49.83-3.06.82-4.65,0-1.63-.28-3.18-.82-4.65-.51-1.41-1.3-2.71-2.3-3.83-1-1.1-2.22-1.99-3.57-2.61-1.4-.65-2.94-.98-4.64-.98s-3.23.33-4.6.98c-1.37.65-2.55,1.52-3.53,2.61-1,1.11-1.77,2.42-2.26,3.83-.53,1.49-.79,3.07-.78,4.65,0,1.63.26,3.18.78,4.65.49,1.42,1.26,2.72,2.26,3.83.99,1.09,2.19,1.98,3.53,2.61,1.37.65,2.9.98,4.6.98s3.25-.32,4.64-.98c1.35-.62,2.57-1.51,3.57-2.61,1-1.12,1.79-2.42,2.3-3.83Zm45.66-23.65h9.07l-14.69,38h-11.25l-14.69-38h9.07l11.25,29.1,11.25-29.1Zm28.59-.98c12.19,0,20.5,10.72,18.94,23.28h-29.7c0,3.28,3.33,9.62,11.25,9.62,6.81,0,11.37-5.95,11.38-5.95l6.05,4.65c-5.41,5.73-9.83,8.37-16.77,8.37-12.39,0-20.79-7.78-20.79-19.98,0-11.03,8.68-19.98,19.64-19.98Zm-10.73,16.67h21.45c-.07-.73-1.23-9.62-10.79-9.62s-10.59,8.88-10.66,9.62Zm35.51,22.3v-57.08h8.95v57.08h-8.95Zm-258.75-57.53c.04.14.06.29.06.44v23.18c0,.61-.33,1.17-.86,1.47l-19.59,11.2v22.2c0,.61-.33,1.16-.86,1.46l-40.89,23.38c-.09.06-.2.09-.3.12-.04.01-.08.04-.11.05-.29.08-.59.08-.87,0-.05-.01-.09-.04-.13-.06-.1-.03-.19-.06-.28-.11l-40.89-23.37c-.53-.3-.85-.86-.85-1.47v-69.53c0-.15.02-.3.06-.44.01-.05.04-.1.06-.14.03-.09.06-.18.11-.26.03-.06.08-.1.11-.15.05-.07.09-.14.15-.2.05-.05.11-.08.17-.13.06-.05.12-.1.19-.14h0s20.45-11.69,20.45-11.69c.53-.3,1.17-.3,1.7,0l20.45,11.69h0c.07.04.12.1.19.14.06.04.12.08.17.13.06.06.1.13.15.2.04.05.08.1.12.15.05.08.08.17.11.26.02.05.04.09.06.14.04.14.06.29.06.44v43.43l17.04-9.74v-22.2c0-.15.02-.3.06-.44.01-.05.04-.09.06-.14.03-.09.06-.18.11-.26.03-.06.08-.1.12-.15.05-.07.09-.14.15-.2.05-.05.11-.08.17-.13.06-.05.12-.11.19-.14h0s20.45-11.69,20.45-11.69c.53-.3,1.17-.3,1.7,0l20.45,11.69h0c.07.04.13.1.19.14.05.04.12.08.17.13.06.06.1.13.15.2.04.05.08.1.12.15.05.08.08.17.11.26.02.05.05.09.06.14Zm-3.35,22.64v-19.27s-7.16,4.09-7.16,4.09l-9.88,5.65v19.27l17.04-9.74h0Zm-20.45,34.87v-19.29l-9.73,5.51-27.76,15.73v19.47l37.49-21.43h0Zm-78.38-65.63v65.63l37.49,21.43v-19.46l-19.58-11h0s0,0,0,0c-.07-.04-.12-.09-.18-.14-.06-.04-.11-.08-.16-.12h0c-.06-.06-.09-.13-.14-.18-.04-.06-.09-.1-.13-.16h0c-.04-.07-.06-.15-.09-.22-.03-.06-.06-.12-.08-.19h0c-.02-.08-.03-.17-.04-.25,0-.06-.03-.13-.03-.19v-45.38l-9.88-5.65-7.16-4.09Zm18.74-12.66l-17.03,9.74,17.03,9.73,17.03-9.74s-17.03-9.74-17.03-9.74Zm8.86,60.76l9.88-5.65v-42.45l-7.15,4.09-9.88,5.65v42.45s7.16-4.09,7.16-4.09Zm52.48-49.27l-17.03,9.73,17.03,9.74,17.03-9.74s-17.03-9.73-17.03-9.73Zm-1.7,22.4l-9.88-5.65-7.15-4.09v19.27s9.88,5.65,9.88,5.65l7.16,4.09v-19.28h0Zm-39.19,43.43l24.98-14.16,12.49-7.08-17.02-9.73-19.6,11.2-17.86,10.21,17.01,9.56Z"
                    fill="#fff" fill-rule="evenodd" stroke-width="0" />
                <path
                    d="m1079.28,301.74s25.08-7.93,30.35,16.34c5.28,24.27-16.79,31.21-16.79,31.21,0,0-9.07.15-26.2-14.44-17.14-14.59-20.62-18.67-20.51-25.07s33.15-8.04,33.15-8.04Z"
                    fill="#1e1f1d" stroke-width="0" />
                <polyline points="1039.24 180.64 974.45 270.23 1051.25 312.81" fill="none" stroke="#1e1f1d"
                    stroke-miterlimit="10" stroke-width="8" />
                <path
                    d="m83.13,318.11c0,.44,42.69.79,95.33.79,52.66,0,95.34-.35,95.34-.79,0-.44-42.68-.79-95.34-.79-52.64,0-95.33.35-95.33.79Z"
                    fill="#192e35" stroke-width="0" />
                <path
                    d="m748.31,128.61c0,.44,30.31.79,67.69.79,37.39,0,67.69-.35,67.69-.79s-30.3-.79-67.69-.79c-37.38,0-67.69.35-67.69.79Z"
                    fill="#192e35" stroke-width="0" />
            </g>
            <g id="Calque_2">
                <g id="Roue2" class="wheel wheel2">
                    <path
                        d="m1455.52,458.31c0,68.48,55.51,123.99,123.99,123.99,68.48,0,123.99-55.51,123.99-123.99s-55.51-123.99-123.99-123.99c-68.48,0-123.99,55.51-123.99,123.99Z"
                        fill="#040203" stroke-width="0" />
                    <path
                        d="m1525.72,494.11c25.73,25.73,22.25-19.46,47.98-45.18,25.73-25.73,70.91-22.25,45.19-47.98-25.73-25.73-67.44-25.73-93.17,0-25.73,25.73-25.73,67.44,0,93.16Z"
                        fill="#d61116" stroke-width="0" />
                    <path
                        d="m1483.73,458.31c0,52.9,42.88,95.78,95.78,95.78,52.9,0,95.78-42.88,95.78-95.78,0-52.89-42.88-95.78-95.78-95.78-52.9,0-95.78,42.88-95.78,95.78Zm17.58,29.05l12.13-1.93-9.98,7.23c-.78-1.74-1.49-3.51-2.15-5.3Zm-3.78-13.41c-.96-5.07-1.52-10.29-1.52-15.64,0-5.23.54-10.33,1.46-15.29l40.72,6.49,12.39,8.98-12.39,8.98-40.67,6.48Zm157.48,19.82l-11.51-8.35,14.08,2.25c-.78,2.08-1.64,4.11-2.58,6.1Zm-36.27-26.3l-12.39-8.98,12.39-8.99,42.74-6.81c.96,5.06,1.51,10.27,1.51,15.61,0,5.46-.56,10.8-1.56,15.97l-42.69-6.8Zm38.97-38.18l-14.2,2.26,11.63-8.44c.94,2.02,1.79,4.07,2.57,6.17Zm-154.37-5.06l10.1,7.32-12.25-1.95c.67-1.82,1.36-3.62,2.15-5.37Zm28.48-34.4l24.53,33.83,2.41,15.11-15.11-2.41-33.6-24.36c5.8-8.69,13.21-16.2,21.77-22.17Zm12.05-6.94c1.83-.87,3.69-1.68,5.6-2.41l2.07,12.98-7.66-10.57Zm35.64-8.07c5,0,9.88.52,14.64,1.36l-6.7,42.04-8.98,12.39-8.98-12.39-6.65-41.73c5.39-1.09,10.96-1.67,16.67-1.67Zm28.08,4.94c2.04.73,4.05,1.51,6.02,2.39l-8.2,11.31,2.18-13.7Zm40.68,31.24l-34.97,25.36-15.12,2.41,2.41-15.11,25.24-34.8c8.81,5.89,16.43,13.42,22.44,22.15Zm-22.63,116.86l-25.05-34.55-2.41-15.11,15.11,2.41,34.8,25.23c-6.03,8.68-13.64,16.17-22.45,22.02Zm-12.24,6.69c-1.92.85-3.89,1.6-5.88,2.31l-2.13-13.36,8.01,11.04Zm-33.9,7.24c-5.69,0-11.24-.58-16.61-1.66l6.59-41.37,8.98-12.39,8.98,12.39,6.64,41.69c-4.74.84-9.6,1.35-14.59,1.35Zm-29.99-5.64c-1.85-.71-3.67-1.5-5.45-2.34l7.47-10.3-2.01,12.64Zm-39.32-31.29l33.45-24.25,15.11-2.41-2.41,15.11-24.36,33.59c-8.55-5.94-15.97-13.4-21.79-22.05Z"
                        fill="#faf0f0" stroke-width="0" />
                    <path
                        d="m1557.46,523.99l-10.45-4.33,14.28-19.69-3.83,24.02Zm42.01,0l-3.82-24.02,14.28,19.69-10.46,4.33Zm-34.93-31.87l3.72-23.43-23.41,3.73,19.19-13.92-19.2-13.93,23.42,3.73-3.72-23.43,13.93,19.21,13.92-19.2-3.74,23.42,23.44-3.73-19.22,13.93,19.21,13.92-23.43-3.73,3.74,23.43-13.92-19.21-13.93,19.21Zm-47.25-2.17l-4.32-10.45,24.02-3.82-19.69,14.28Zm122.34,0l-19.69-14.27,24.01,3.82-4.32,10.45Zm-19.69-48.64l19.69-14.28,4.33,10.45-24.02,3.83Zm-82.96,0l-24.01-3.83,4.32-10.45,19.69,14.27Zm24.3-24.3l-14.28-19.69,10.46-4.33,3.82,24.02Zm34.36,0l3.83-24.01,10.45,4.32-14.27,19.69Z"
                        fill="#9a9999" stroke-width="0" />
                    <path
                        d="m1579.51,351.91c-63.69,0-115.56,49.97-118.92,112.82-.11-2.14-.32-4.25-.32-6.42,0-65.86,53.39-119.24,119.25-119.24,65.86,0,119.24,53.39,119.24,119.24,0,2.17-.21,4.28-.32,6.42-3.36-62.85-55.23-112.82-118.92-112.82Z"
                        fill="#262626" stroke-width="0" />
                    <path
                        d="m1579.51,554.55c51.54,0,93.51-40.44,96.23-91.29.09,1.73.26,3.44.26,5.2,0,53.29-43.2,96.49-96.49,96.49-53.29,0-96.49-43.2-96.49-96.49,0-1.75.17-3.46.26-5.2,2.72,50.86,44.69,91.29,96.23,91.29Z"
                        fill="#262626" stroke-width="0" />
                </g>
                <g id="Roue1" class="wheel wheel1">
                    <path
                        d="m534.39,457.57c0,68.48,55.51,123.99,123.99,123.99s123.99-55.51,123.99-123.99c0-68.48-55.51-123.99-123.99-123.99-68.48,0-123.99,55.51-123.99,123.99Z"
                        fill="#040203" stroke-width="0" />
                    <path
                        d="m604.59,493.37c25.73,25.73,22.25-19.46,47.98-45.18,25.73-25.73,70.91-22.25,45.19-47.98-25.73-25.73-67.44-25.73-93.17,0-25.73,25.73-25.73,67.44,0,93.16Z"
                        fill="#d61116" stroke-width="0" />
                    <path
                        d="m562.6,457.57c0,52.9,42.88,95.78,95.78,95.78s95.78-42.88,95.78-95.78c0-52.89-42.88-95.78-95.78-95.78-52.9,0-95.78,42.88-95.78,95.78Zm17.58,29.05l12.13-1.93-9.98,7.23c-.78-1.74-1.49-3.51-2.15-5.3Zm-3.78-13.41c-.96-5.07-1.52-10.29-1.52-15.64,0-5.23.54-10.33,1.46-15.29l40.72,6.49,12.39,8.98-12.39,8.98-40.67,6.48Zm157.48,19.82l-11.51-8.35,14.08,2.25c-.78,2.08-1.64,4.11-2.58,6.1Zm-36.27-26.3l-12.39-8.98,12.39-8.99,42.74-6.81c.96,5.06,1.51,10.27,1.51,15.61,0,5.46-.56,10.8-1.56,15.97l-42.69-6.8Zm38.97-38.18l-14.2,2.26,11.63-8.44c.94,2.02,1.79,4.07,2.57,6.17Zm-154.37-5.06l10.1,7.32-12.25-1.95c.67-1.82,1.36-3.62,2.15-5.37Zm28.48-34.4l24.53,33.83,2.41,15.11-15.11-2.41-33.6-24.36c5.8-8.69,13.21-16.2,21.77-22.17Zm12.05-6.94c1.83-.87,3.69-1.68,5.6-2.41l2.07,12.98-7.66-10.57Zm35.64-8.07c5,0,9.88.52,14.64,1.36l-6.7,42.04-8.98,12.39-8.98-12.39-6.65-41.73c5.39-1.09,10.96-1.67,16.67-1.67Zm28.08,4.94c2.04.73,4.05,1.51,6.02,2.39l-8.2,11.31,2.18-13.7Zm40.68,31.24l-34.97,25.36-15.12,2.41,2.41-15.11,25.24-34.8c8.81,5.89,16.43,13.42,22.44,22.15Zm-22.63,116.86l-25.05-34.55-2.41-15.11,15.11,2.41,34.8,25.23c-6.03,8.68-13.64,16.17-22.45,22.02Zm-12.24,6.69c-1.92.85-3.89,1.6-5.88,2.31l-2.13-13.36,8.01,11.04Zm-33.9,7.24c-5.69,0-11.24-.58-16.61-1.66l6.59-41.37,8.98-12.39,8.98,12.39,6.64,41.69c-4.74.84-9.6,1.35-14.59,1.35Zm-29.99-5.64c-1.85-.71-3.67-1.5-5.45-2.34l7.47-10.3-2.01,12.64Zm-39.32-31.29l33.45-24.25,15.11-2.41-2.41,15.11-24.36,33.59c-8.55-5.94-15.97-13.4-21.79-22.05Z"
                        fill="#faf0f0" stroke-width="0" />
                    <path
                        d="m636.33,523.24l-10.45-4.33,14.28-19.69-3.83,24.02Zm42.01,0l-3.82-24.02,14.28,19.69-10.46,4.33Zm-34.93-31.87l3.72-23.43-23.41,3.73,19.19-13.92-19.2-13.93,23.42,3.73-3.72-23.43,13.93,19.21,13.92-19.2-3.74,23.42,23.44-3.73-19.22,13.93,19.21,13.92-23.43-3.73,3.74,23.43-13.92-19.21-13.93,19.21Zm-47.25-2.17l-4.32-10.45,24.02-3.82-19.69,14.28Zm122.34,0l-19.69-14.27,24.01,3.82-4.32,10.45Zm-19.69-48.64l19.69-14.28,4.33,10.45-24.02,3.83Zm-82.96,0l-24.01-3.83,4.32-10.45,19.69,14.27Zm24.3-24.3l-14.28-19.69,10.46-4.33,3.82,24.02Zm34.36,0l3.83-24.01,10.45,4.32-14.27,19.69Z"
                        fill="#9a9999" stroke-width="0" />
                    <path
                        d="m658.38,351.17c-63.69,0-115.56,49.97-118.92,112.82-.11-2.14-.32-4.25-.32-6.42,0-65.86,53.39-119.24,119.25-119.24,65.86,0,119.24,53.39,119.24,119.24,0,2.17-.21,4.28-.32,6.42-3.36-62.85-55.23-112.82-118.92-112.82Z"
                        fill="#262626" stroke-width="0" />
                    <path
                        d="m658.38,553.8c51.54,0,93.51-40.44,96.23-91.29.09,1.73.26,3.44.26,5.2,0,53.29-43.2,96.49-96.49,96.49-53.29,0-96.49-43.2-96.49-96.49,0-1.75.17-3.46.26-5.2,2.72,50.86,44.69,91.29,96.23,91.29Z"
                        fill="#262626" stroke-width="0" />
                </g>
            </g>
        </svg>
        @endif

        <div id="swagger-ui" class="api-platform"></div>
        <script src="/vendor/api-platform/swagger-ui/swagger-ui-bundle.js"></script>
        <script src="/vendor/api-platform/swagger-ui/swagger-ui-standalone-preset.js"></script>
        <script src="/vendor/api-platform/init-swagger-ui.js"></script>
    </body>
</html>
