<?php

/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

declare(strict_types=1);

return [
    'legacy' => [
        'files' => [
            '.env.local.php',
            'bootstrap.php',
            'container.php',
            'tests/php/bootstrap.php',
            'tests/php/polyfill.php',
        ],
        'directories' => [
            'api',
            'config',
            'cron',
            'lib',
            'libinstall',
            'packaging',
            'src/Centreon',
            'src/CentreonCommand',
            'src/CentreonLegacy',
            'src/CentreonModule',
            'src/CentreonNotification',
            'src/CentreonRemote',
            'src/CentreonUser',
            'src/EventSubscriber',
            'src/Security',
            'src/Utility',
            'tools',
            'www',
            'tests/php/Centreon',
            'tests/php/CentreonLegacy',
            'tests/php/CentreonRemote',
            'tests/php/mock',
            'tests/php/Security',
            'tests/php/Utility',
            'tests/php/www',
        ],
        'skip' => [
            'centreon.config.php', // Exclude the config file because it is generated by the installer
        ],
    ],
    'core' => [
        'files' => [
            'src/Centreon/Infrastructure/DatabaseConnection.php',
        ],
        'directories' => [
            'src/Core',
            'tests/php/Core',
        ],
        'skip' => [],
    ],
    'new' => [
        'files' => [
            '.php-cs-fixer.conf.php',
            '.php-cs-fixer.diff.php',
            '.php-cs-fixer.core.php',
            '.php-cs-fixer.legacy.php',
            '.php-cs-fixer.new.php',
            'castor.php',
            'rector.conf.php',
            'rector.core.php',
            'rector.diff.php',
            'rector.legacy.php',
            'rector.new.php',
        ],
        'directories' => [
            'config.new',
            'src/Adaptation',
            'src/App',
            'tests/php/Adaptation',
            'tests/php/App',
        ],
        'skip' => [],
    ],
];
