import { SvgIcon, SvgIconProps } from '@mui/material';

export const ServiceIcon = (props: SvgIconProps): JSX.Element => (
  <SvgIcon {...props}>
    <g>
      <circle cx="9.67" cy="5" r="2" />
      <circle cx="5" cy="9.67" r="2" />
      <circle cx="9.67" cy="14.33" r="2" />
      <circle cx="14.33" cy="9.67" r="2" />
      <circle cx="19" cy="5" r="2" />
      <circle cx="19" cy="14.33" r="2" />
      <circle cx="14.33" cy="19" r="2" />
      <circle cx="5" cy="19" r="2" />
    </g>
  </SvgIcon>
);

export const MetaServiceIcon = (props: SvgIconProps): JSX.Element => (
  <SvgIcon {...props}>
    <g>
      <circle cx="12" cy="5.09" r="2.09" />
      <circle cx="5.09" cy="12" r="2.09" />
      <circle cx="12" cy="18.91" r="2.09" />
      <circle cx="18.91" cy="12" r="2.09" />
      <path d="M15.19,7.37c.57.39,1.06.88,1.44,1.44-1.02.73-1.64,1.9-1.64,3.19s.61,2.46,1.64,3.19c-.39.57-.88,1.06-1.44,1.44-.73-1.02-1.9-1.64-3.19-1.64s-2.46.61-3.19,1.64c-.57-.39-1.06-.88-1.44-1.44,1.02-.73,1.64-1.9,1.64-3.19s-.61-2.46-1.64-3.19c.39-.57.88-1.06,1.44-1.44.73,1.02,1.9,1.64,3.19,1.64s2.46-.61,3.19-1.64M14.99,6.57c-.55,1.1-1.68,1.86-2.99,1.86s-2.44-.76-2.99-1.86c-1.03.57-1.88,1.42-2.44,2.44,1.1.55,1.86,1.68,1.86,2.99s-.76,2.44-1.86,2.99c.57,1.03,1.42,1.88,2.44,2.44.55-1.1,1.68-1.86,2.99-1.86s2.44.76,2.99,1.86c1.03-.57,1.88-1.42,2.44-2.44-1.1-.55-1.86-1.68-1.86-2.99s.76-2.44,1.86-2.99c-.57-1.03-1.42-1.88-2.44-2.44h0Z" />
    </g>
  </SvgIcon>
);

export const AnomalyDetectionIcon = (props: SvgIconProps): JSX.Element => (
  <SvgIcon {...props}>
    <g>
      <path d="M9.72,11.03c0-2.17,1.76-3.92,3.92-3.92s3.92,1.76,3.92,3.92c0,1.31-.64,2.46-1.62,3.18-.65.47-4.02.45-4.68-.06-.94-.72-1.54-1.85-1.54-3.12Z" />
      <rect height=".57" rx=".28" ry=".28" width="5.39" x="10.96" y="14.03" />
      <rect height=".57" rx=".27" ry=".27" width="5.05" x="11.13" y="14.79" />
      <path d="M11.31,15.88h4.68c0,.92-1.05,1.67-2.34,1.67s-2.34-.75-2.34-1.67Z" />
      <circle cx="13.66" cy="17.42" r=".87" />
      <rect height="2.09" rx=".38" ry=".38" width=".77" x="13.34" y="3.67" />
      <rect
        height="2.09"
        rx=".38"
        ry=".38"
        transform="translate(10 -10.9) rotate(45)"
        width=".77"
        x="17.78"
        y="5.58"
      />
      <rect
        height="2.09"
        rx=".38"
        ry=".38"
        transform="translate(31.07 -8.84) rotate(90)"
        width=".77"
        x="19.57"
        y="10.07"
      />
      <rect
        height="2.09"
        rx=".38"
        ry=".38"
        transform="translate(41.8 13.79) rotate(135)"
        width=".77"
        x="17.66"
        y="14.51"
      />
      <circle cx="7.64" cy="8.47" r="1.32" />
      <circle cx="4.32" cy="11.79" r="1.32" />
      <circle cx="7.64" cy="15.1" r="1.32" />
      <circle cx="10.95" cy="18.41" r="1.32" />
      <circle cx="4.32" cy="18.41" r="1.32" />
    </g>
  </SvgIcon>
);

export const BAIcon = (props: SvgIconProps): JSX.Element => (
  <SvgIcon {...props}>
    <g>
      <path d="M11.91,21.58l-4.96-2.85v-5.73l4.96-2.86,4.96,2.86v5.73l-4.96,2.85ZM7.95,18.15l3.96,2.28,3.96-2.28v-4.57l-3.96-2.29-3.96,2.29v4.57Z" />
      <path d="M7.45,13.87l-4.95-2.87v-5.73l4.95-2.85,4.96,2.85v5.73l-4.96,2.86ZM3.5,10.42l3.95,2.29,3.96-2.29v-4.57l-3.96-2.28-3.95,2.28v4.57Z" />
      <path d="M16.37,13.87l-4.96-2.87v-5.73l4.96-2.85,4.95,2.85v5.73l-4.95,2.86ZM12.41,10.42l3.96,2.29,3.95-2.29v-4.57l-3.95-2.28-3.96,2.28v4.57Z" />
    </g>
  </SvgIcon>
);

export const BooleanRuleIcon = (props: SvgIconProps): JSX.Element => (
  <SvgIcon {...props}>
    <g>
      <path d="M8.5 18.5C4.92 18.5 2 15.58 2 12C2 8.42 4.92 5.5 8.5 5.5C12.08 5.5 15 8.42 15 12C15 15.58 12.08 18.5 8.5 18.5ZM8.5 6.5C5.47 6.5 3 8.97 3 12C3 15.03 5.47 17.5 8.5 17.5C11.53 17.5 14 15.03 14 12C14 8.97 11.53 6.5 8.5 6.5Z" />
      <path d="M15.5 18.5C11.92 18.5 9 15.58 9 12C9 8.42 11.92 5.5 15.5 5.5C19.08 5.5 22 8.42 22 12C22 15.58 19.08 18.5 15.5 18.5ZM15.5 6.5C12.47 6.5 10 8.97 10 12C10 15.03 12.47 17.5 15.5 17.5C18.53 17.5 21 15.03 21 12C21 8.97 18.53 6.5 15.5 6.5Z" />
      <path d="M9 12C9 9.78 10.13 7.72 12 6.52C13.87 7.71 15 9.78 15 12C15 14.22 13.87 16.28 12 17.48C10.13 16.29 9 14.22 9 12Z" />
    </g>
  </SvgIcon>
);
