<?php

/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

require_once realpath(__DIR__ . '/../../../../../config/centreon.config.php');
require_once _CENTREON_PATH_ . '/www/class/centreonDB.class.php';
require_once _CENTREON_PATH_ . '/www/include/common/common-Func.php';

// Validate the session
session_start();
$db = new CentreonDB();
$sid = session_id();
if (isset($sid)) {
    $res = $db->query('SELECT * FROM session WHERE session_id = \'' . CentreonDB::escape($sid) . '\'');
    if (! $res->fetchRow()) {
        header($_SERVER['SERVER_PROTOCOL'] . ' 401 Unauthorized', true, 401);

        exit;
    }
} else {
    header($_SERVER['SERVER_PROTOCOL'] . ' 401 Unauthorized', true, 401);

    exit;
}

/**
 * return Resolved host name
 */
echo gethostbyname(htmlspecialchars($_GET['hostName']));
