<?php

/*
 * Copyright 2005 - 2025 Centreon (https://www.centreon.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * For more information : contact@centreon.com
 *
 */

declare(strict_types=1);

namespace Tests\App\ResourceConfiguration\Infrastructure\Double;

use App\ResourceConfiguration\Domain\Aggregate\ServiceCategory;
use App\ResourceConfiguration\Domain\Aggregate\ServiceCategoryId;
use App\ResourceConfiguration\Domain\Aggregate\ServiceCategoryName;
use App\ResourceConfiguration\Domain\Repository\ServiceCategoryRepository;
use App\Shared\Domain\Aggregate\AggregateRoot;

final class FakeServiceCategoryRepository implements ServiceCategoryRepository
{
    /** @var array<int, ServiceCategory> */
    public array $serviceCategories = [];

    public function add(ServiceCategory $serviceCategory): void
    {
        do {
            $id = mt_rand();
        } while (isset($this->serviceCategories[$id]));

        $reflection = new \ReflectionProperty(AggregateRoot::class, 'id');
        $reflection->setAccessible(true);
        $reflection->setValue($serviceCategory, new ServiceCategoryId($id));

        $this->serviceCategories[$id] = $serviceCategory;
    }

    public function findOneByName(ServiceCategoryName $name): ?ServiceCategory
    {
        foreach ($this->serviceCategories as $serviceCategory) {
            if ($serviceCategory->name->value === $name->value) {
                return $serviceCategory;
            }
        }

        return null;
    }
}
