/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.1.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

import java.lang.AutoCloseable;
import java.util.Optional;
import java.util.Map;

/**
 * ModelGroup objects are used to group model blocks. The grouping is established by<br>
 * assignment of a ModelGroup instance to the Model.group attribute of participating models.
 */
public class ModelGroup implements AutoCloseable {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected ModelGroup(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ModelGroup obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ModelGroup obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_ModelGroup(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  @Override
  public void close() {
    delete();
  }

  public ModelGroup(ModelGroup model_group) {
    this(MetashapeJNI.new_ModelGroup(ModelGroup.getCPtr(model_group), model_group), true);
  }

  /**
   *  Model group key.
   */
  public int getKey() {
    return MetashapeJNI.ModelGroup_getKey(swigCPtr, this);
  }

  /**
   *  Chunk container, may be null.
   */
  public Optional<Chunk> getChunk() {
    long ptr = MetashapeJNI.ModelGroup_getChunk(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Chunk(ptr, true));
  }

  /**
   *  Model group label.
   */
  public void setLabel(String label) {
    MetashapeJNI.ModelGroup_setLabel(swigCPtr, this, label);
  }

  /**
   *  Model group label.
   */
  public String getLabel() {
    return MetashapeJNI.ModelGroup_getLabel(swigCPtr, this);
  }

  /**
   *  Current selection state.
   */
  public void setSelected(boolean state) {
    MetashapeJNI.ModelGroup_setSelected(swigCPtr, this, state);
  }

  /**
   *  Current selection state.
   */
  public boolean isSelected() {
    return MetashapeJNI.ModelGroup_isSelected(swigCPtr, this);
  }

  /**
   *  Model group meta data.
   */
  public void setMeta(Map<String,String> meta) {
    MetashapeJNI.ModelGroup_setMeta(swigCPtr, this, meta);
  }

  /**
   *  Model group meta data.
   */
  public Map<String,String> getMeta() { return MetashapeJNI.ModelGroup_getMeta(swigCPtr, this); }

  /**
   * Generate block model preview image.<br>
   * @param width Preview image width.<br>
   * @param height Preview image height.<br>
   * @param transform 4x4 viewpoint transformation matrix.<br>
   * @return Preview image.
   */
  public Image renderPreview(long width, long height, Matrix transform, Progress progress) {
    return new Image(MetashapeJNI.ModelGroup_renderPreview(swigCPtr, this, width, height, transform, progress), true);
  }

}
