/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.1.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

import java.lang.AutoCloseable;
import java.util.Optional;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * NetworkClient class provides access to the network processing server and allows<br>
 * to create and manage tasks.
 */
public class NetworkClient implements AutoCloseable {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected NetworkClient(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(NetworkClient obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(NetworkClient obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_NetworkClient(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  @Override
  public void close() {
    delete();
  }

  static public class OutputRecord {

    private int type;
    private String text;

    public void setType(int type) {
      this.type = type;
    }

    public int getType() {
      return this.type;
    }

    public void setText(String text) {
      this.text = text;
    }

    public String getText() {
      return text;
    }

  }

  static public class ResourceRecord {

    private double time;
    private double memory_usage;
    private double cpu_usage;

    public void setTime(double value) {
      this.time = value;
    }

    public double getTime() {
      return time;
    }

    public void setMemoryUsage(double value) {
      this.memory_usage = value;
    }

    public double getMemoryUsage() {
      return memory_usage;
    }

    public void setCpuUsage(double value) {
      this.cpu_usage = value;
    }

    public double getCpuUsage() {
      return cpu_usage;
    }

  }

  static public class ServerVersion {

    private String name;
    private String version;

    public void setName(String value) {
      this.name = value;
    }

    public String getName() {
      return name;
    }

    public void setVersion(String value) {
      this.version = value;
    }

    public String getVersion() {
      return version;
    }

  }

  static public class ServerInfo {

    private String name;
    private String version;
    private long started_at;
    private double memory_size;
    private int scheduling_mode;
    private long next_revision;
    private NetworkClient.OutputRecord[] output;
    private NetworkClient.ResourceRecord[] resource_usage;

    public void setName(String value) {
      this.name = value;
    }

    public String getName() {
      return name;
    }

    public void setVersion(String value) {
      this.version = value;
    }

    public String getVersion() {
      return version;
    }

    public void setStartedAt(long value) {
      this.started_at = value;
    }

    public long getStartedAt() {
      return started_at;
    }

    public void setMemorySize(double value) {
      this.memory_size = value;
    }

    public double getMemorySize() {
      return memory_size;
    }

    public void setSchedulingMode(int value) {
      this.scheduling_mode = value;
    }

    public int getSchedulingMode() {
      return scheduling_mode;
    }

    public void setNextRevision(long value) {
      this.next_revision = value;
    }

    public long getNextRevision() {
      return next_revision;
    }

    public void setOutput(NetworkClient.OutputRecord[] value) {
      this.output = value;
    }

    public NetworkClient.OutputRecord[] getOutput() { return output; }

    public void setResourceUsage(NetworkClient.ResourceRecord[] value) {
      this.resource_usage = value;
    }

    public NetworkClient.ResourceRecord[] getResourceUsage() { return resource_usage; }

  }

  static public class TaskInfo {

    private NetworkTask task;
    private NetworkClient.State state;
    private boolean aborted;
    private boolean failed;
    private double progress;
    private double elapsed_time;
    private double remaining_time;
    private double processing_time;
    private int target_count;
    private int targets_completed;
    private int workitems_waiting;
    private int workitems_inprogress;
    private int workitems_completed;
    private int workitems_failed;
    private NetworkClient.OutputRecord[] output;

    public void update(NetworkClient.TaskInfo update) {
      this.task = update.task;
      this.state = update.state;
      this.aborted = update.aborted;
      this.failed = update.failed;
      this.progress = update.progress;
      this.elapsed_time = update.elapsed_time;
      this.remaining_time = update.remaining_time;
      this.processing_time = update.processing_time;
      this.target_count = update.target_count;
      this.targets_completed = update.targets_completed;
      this.workitems_waiting = update.workitems_waiting;
      this.workitems_inprogress = update.workitems_inprogress;
      this.workitems_completed = update.workitems_completed;
      this.workitems_failed = update.workitems_failed;

      NetworkClient.OutputRecord[] new_output = new NetworkClient.OutputRecord[this.output.length + update.output.length];
      for (int k = 0; k < this.output.length; k++)
        new_output[k] = this.output[k];
      for (int k = 0; k < update.output.length; k++)
        new_output[this.output.length + k] = update.output[k];
      this.output = new_output;
    }

    public void setTask(NetworkTask value) {
      this.task = value;
    }

    public NetworkTask getTask() { return this.task; }

    public void setState(NetworkClient.State value) {
      this.state = value;
    }

    public NetworkClient.State getState() {
      return this.state;
    }

    public void setAborted(boolean value) {
      this.aborted = value;
    }

    public boolean isAborted() {
      return this.aborted;
    }

    public void setFailed(boolean value) {
      this.failed = value;
    }

    public boolean isFailed() {
      return this.failed;
    }

    public void setProgress(double value) {
      this.progress = value;
    }

    public double getProgress() {
      return progress;
    }

    public void setElapsedTime(double value) {
      this.elapsed_time = value;
    }

    public double getElapsedTime() {
      return elapsed_time;
    }

    public void setRemainingTime(double value) {
      this.remaining_time = value;
    }

    public double getRemainingTime() {
      return remaining_time;
    }

    public void setProcessingTime(double value) {
      this.processing_time = value;
    }

    public double getProcessingTime() {
      return processing_time;
    }

    public void setTargetCount(int value) {
      this.target_count = value;
    }

    public int getTargetCount() {
      return target_count;
    }

    public void setTargetsCompleted(int value) {
      this.targets_completed = value;
    }

    public int getTargetsCompleted() {
      return targets_completed;
    }

    public void setWorkitemsWaiting(int value) {
      this.workitems_waiting = value;
    }

    public int getWorkitemsWaiting() {
      return workitems_waiting;
    }

    public void setWorkitemsInprogress(int value) {
      this.workitems_inprogress = value;
    }

    public int getWorkitemsInprogress() {
      return workitems_inprogress;
    }

    public void setWorkitemsCompleted(int value) {
      this.workitems_completed = value;
    }

    public int getWorkitemsCompleted() {
      return workitems_completed;
    }

    public void setWorkitemsFailed(int value) {
      this.workitems_failed = value;
    }

    public int getWorkitemsFailed() {
      return workitems_failed;
    }

    public void setOutput(NetworkClient.OutputRecord[] value) {
      this.output = value;
    }

    public NetworkClient.OutputRecord[] getOutput() { return output; }

  }

  static public class BatchInfo {

    private String path;
    private String uuid;
    private Map<String, String> meta;
    private String username;
    private String min_worker_version;
    private String max_worker_version;
    private String worker_version;
    private NetworkClient.State state;
    private boolean aborted;
    private boolean failed;
    private boolean paused;
    private int priority;
    private int worker_limit;
    private long started_at;
    private long finished_at;
    private NetworkClient.TaskInfo[] tasks;
    private long error_time;
    private long error_worker_id;
    private String error_message;
    private long next_revision;

    public void update(NetworkClient.BatchInfo update) {
      this.path = update.path;
      this.uuid = update.uuid;
      this.meta = update.meta;
      this.username = update.username;
      this.min_worker_version = update.min_worker_version;
      this.max_worker_version = update.max_worker_version;
      this.worker_version = update.worker_version;
      this.state = update.state;
      this.aborted = update.aborted;
      this.failed = update.failed;
      this.paused = update.paused;
      this.priority = update.priority;
      this.started_at = update.started_at;
      this.finished_at = update.finished_at;
      this.error_time = update.error_time;
      this.error_worker_id = update.error_worker_id;
      this.error_message = update.error_message;
      this.next_revision = update.next_revision;

      NetworkClient.TaskInfo[] new_tasks = new NetworkClient.TaskInfo[update.tasks.length];
      for (int k = 0; k < update.tasks.length; k++) {
        if (k < this.tasks.length) {
          new_tasks[k] = this.tasks[k];
          new_tasks[k].update(update.tasks[k]);
        } else {
          new_tasks[k] = update.tasks[k];
        }
      }
      this.tasks = new_tasks;
    }

    public void setPath(String value) {
      this.path = value;
    }

    public String getPath() {
      return path;
    }

    public void setUuid(String value) {
      this.uuid = value;
    }

    public String getUuid() {
      return uuid;
    }

    public void setMeta(Map<String, String> value) {
      this.meta = value;
    }

    public Map<String, String> getMeta() { return meta; }

    public void setUsername(String value) {
      this.username = value;
    }

    public String getUsername() {
      return username;
    }

    public void setMinWorkerVersion(String value) {
      this.min_worker_version = value;
    }

    public String getMinWorkerVersion() {
      return min_worker_version;
    }

    public void setMaxWorkerVersion(String value) {
      this.max_worker_version = value;
    }

    public String getMaxWorkerVersion() {
      return max_worker_version;
    }

    public void setWorkerVersion(String value) {
      this.worker_version = value;
    }

    public String getWorkerVersion() {
      return worker_version;
    }

    public void setState(NetworkClient.State value) {
      this.state = value;
    }

    public NetworkClient.State getState() {
      return state;
    }

    public void setAborted(boolean value) {
      this.aborted = value;
    }

    public boolean isAborted() {
      return aborted;
    }

    public void setFailed(boolean value) {
      this.failed = value;
    }

    public boolean isFailed() {
      return failed;
    }

    public void setPaused(boolean value) {
      this.paused = value;
    }

    public boolean isPaused() {
      return paused;
    }

    public void setPriority(int value) {
      this.priority = value;
    }

    public int getPriority() {
      return priority;
    }

    public void setWorkerLimit(int value) {
      this.worker_limit = value;
    }

    public int getWorkerLimit() {
      return worker_limit;
    }

    public void setStartedAt(long value) {
      this.started_at = value;
    }

    public long getStartedAt() {
      return started_at;
    }

    public void setFinishedAt(long value) {
      this.finished_at = value;
    }

    public long getFinishedAt() {
      return finished_at;
    }

    public void setTasks(NetworkClient.TaskInfo[] value) {
      this.tasks = value;
    }

    public NetworkClient.TaskInfo[] getTasks() { return tasks; }

    public void setErrorTime(long value) {
      this.error_time = value;
    }

    public long getErrorTime() {
      return error_time;
    }

    public void setErrorWorkerId(long value) {
      this.error_worker_id = value;
    }

    public long getErrorWorkerId() {
      return error_worker_id;
    }

    public void setErrorMessage(String value) {
      this.error_message = value;
    }

    public String getErrorMessage() {
      return error_message;
    }

    public void setNextRevision(long value) {
      this.next_revision = value;
    }

    public long getNextRevision() {
      return next_revision;
    }

  }

  static public class BatchItem {

    private long batch_id;
    private String path;
    private String uuid;
    private Map<String, String> meta;
    private String username;
    private NetworkClient.State state;
    private boolean aborted;
    private boolean failed;
    private boolean paused;
    private int priority;
    private int worker_limit;
    private String min_worker_version;
    private String max_worker_version;
    private String worker_version;
    private long started_at;
    private long finished_at;
    private NetworkClient.TaskInfo task_info;

    public void setBatchId(long value) {
      this.batch_id = value;
    }

    public long getBatchId() {
      return batch_id;
    }

    public void setPath(String value) {
      this.path = value;
    }

    public String getPath() {
      return path;
    }

    public void setUuid(String value) {
      this.uuid = value;
    }

    public String getUuid() {
      return uuid;
    }

    public void setMeta(Map<String, String> value) {
      this.meta = value;
    }

    public Map<String, String> getMeta() { return meta; }

    public void setUsername(String value) {
      this.username = value;
    }

    public String getUsername() {
      return username;
    }

    public void setState(NetworkClient.State value) {
      this.state = value;
    }

    public NetworkClient.State getState() {
      return state;
    }

    public void setAborted(boolean value) {
      this.aborted = value;
    }

    public boolean isAborted() {
      return aborted;
    }

    public void setFailed(boolean value) {
      this.failed = value;
    }

    public boolean isFailed() {
      return failed;
    }

    public void setPaused(boolean value) {
      this.paused = value;
    }

    public boolean isPaused() {
      return paused;
    }

    public void setPriority(int value) {
      this.priority = value;
    }

    public int getPriority() {
      return priority;
    }

    public void setWorkerLimit(int value) {
      this.worker_limit = value;
    }

    public int getWorkerLimit() {
      return worker_limit;
    }

    public void setMinWorkerVersion(String value) {
      this.min_worker_version = value;
    }

    public String getMinWorkerVersion() {
      return min_worker_version;
    }

    public void setMaxWorkerVersion(String value) {
      this.max_worker_version = value;
    }

    public String getMaxWorkerVersion() {
      return max_worker_version;
    }

    public void setWorkerVersion(String value) {
      this.worker_version = value;
    }

    public String getWorkerVersion() {
      return worker_version;
    }

    public void setStartedAt(long value) {
      this.started_at = value;
    }

    public long getStartedAt() {
      return started_at;
    }

    public void setFinishedAt(long value) {
      this.finished_at = value;
    }

    public long getFinishedAt() {
      return finished_at;
    }

    public void setTaskInfo(NetworkClient.TaskInfo value) {
      this.task_info = value;
    }

    public NetworkClient.TaskInfo getTaskInfo() {
      return task_info;
    }

  }

  static public class WorkerInfo {

    private String uuid;
    private String hostname;
    private String hostaddr;
    private double memory_size;
    private long gpu_mask;
    private boolean cpu_enabled;
    private long next_revision;
    private NetworkClient.OutputRecord[] output;
    private NetworkClient.ResourceRecord[] resource_usage;

    public void setUuid(String value) {
      this.uuid = value;
    }

    public String getUuid() {
      return uuid;
    }

    public void setHostname(String value) {
      this.hostname = value;
    }

    public String getHostname() {
      return hostname;
    }

    public void setHostaddr(String value) {
      this.hostaddr = value;
    }

    public String getHostaddr() {
      return hostaddr;
    }

    public void setMemorySize(double value) {
      this.memory_size = value;
    }

    public double getMemorySize() {
      return memory_size;
    }

    public void setGpuMask(long value) {
      this.gpu_mask = value;
    }

    public long getGpuMask() {
      return gpu_mask;
    }

    public void setCpuEnabled(boolean value) {
      this.cpu_enabled = value;
    }

    public boolean isCpuEnabled() {
      return cpu_enabled;
    }

    public void setNextRevision(long value) {
      this.next_revision = value;
    }

    public long getNextRevision() {
      return next_revision;
    }

    public void setOutput(NetworkClient.OutputRecord[] value) {
      this.output = value;
    }

    public NetworkClient.OutputRecord[] getOutput() { return output; }

    public void setResourceUsage(NetworkClient.ResourceRecord[] value) {
      this.resource_usage = value;
    }

    public NetworkClient.ResourceRecord[] getResourceUsage() { return resource_usage; }

  }

  static public class WorkerItem {

    private String uuid;
    private String hostaddr;
    private String hostname;
    private long worker_id;
    private String version;
    private NetworkClient.State state;
    private boolean aborted;
    private boolean paused;
    private int priority;
    private long connected_at;
    private long disconnected_at;
    private int capability;
    private double memory_size;
    private long gpu_mask;
    private boolean cpu_enabled;
    private long batch_id;
    private double progress;
    private NetworkTask task;
    private long error_count;
    private long error_time;
    private long error_batch_id;
    private String error_message;
    private NetworkClient.ResourceRecord resource_usage;

    public void setUuid(String value) {
      this.uuid = value;
    }

    public String getUuid() {
      return uuid;
    }

    public void setHostaddr(String value) {
      this.hostaddr = value;
    }

    public String getHostaddr() {
      return hostaddr;
    }

    public void setHostname(String value) {
      this.hostname = value;
    }

    public String getHostname() {
      return hostname;
    }

    public void setWorkerId(long value) {
      this.worker_id = value;
    }

    public long getWorkerId() {
      return worker_id;
    }

    public void setVersion(String value) {
      this.version = value;
    }

    public String getVersion() {
      return version;
    }

    public void setState(NetworkClient.State value) {
      this.state = value;
    }

    public NetworkClient.State getState() {
      return state;
    }

    public void setAborted(boolean value) {
      this.aborted = value;
    }

    public boolean isAborted() {
      return aborted;
    }

    public void setPaused(boolean value) {
      this.paused = value;
    }

    public boolean isPaused() {
      return paused;
    }

    public void setPriority(int value) {
      this.priority = value;
    }

    public int getPriority() {
      return priority;
    }

    public void setConnectedAt(long value) {
      this.connected_at = value;
    }

    public long getConnectedAt() {
      return connected_at;
    }

    public void setDisconnectedAt(long value) {
      this.disconnected_at = value;
    }

    public long getDisconnectedAt() {
      return disconnected_at;
    }

    public void setCapability(int value) {
      this.capability = value;
    }

    public int getCapability() {
      return capability;
    }

    public void setMemorySize(double value) {
      this.memory_size = value;
    }

    public double getMemorySize() {
      return memory_size;
    }

    public void setGpuMask(long value) {
      this.gpu_mask = value;
    }

    public long getGpuMask() {
      return gpu_mask;
    }

    public void setCpuEnabled(boolean value) {
      this.cpu_enabled = value;
    }

    public boolean isCpuEnabled() {
      return cpu_enabled;
    }

    public void setBatchId(long value) {
      this.batch_id = value;
    }

    public long getBatchId() {
      return batch_id;
    }

    public void setProgress(double value) {
      this.progress = value;
    }

    public double getProgress() {
      return progress;
    }

    public void setTask(NetworkTask value) {
      this.task = value;
    }

    public NetworkTask getTask() { return task; }

    public void setErrorCount(long value) {
      this.error_count = value;
    }

    public long getErrorCount() {
      return error_count;
    }

    public void setErrorTime(long value) {
      this.error_time = value;
    }

    public long getErrorTime() {
      return error_time;
    }

    public void setErrorBatchId(long value) {
      this.error_batch_id = value;
    }

    public long getErrorBatchId() {
      return error_batch_id;
    }

    public void setErrorMessage(String value) {
      this.error_message = value;
    }

    public String getErrorMessage() {
      return error_message;
    }

    public void setResourceUsage(NetworkClient.ResourceRecord value) {
      this.resource_usage = value;
    }

    public NetworkClient.ResourceRecord getResourceUsage() { return resource_usage; }

  }

  static public class BatchList {

    private NetworkClient.BatchItem[] batches;
    private long next_revision;

    public void update(NetworkClient.BatchList update) {
      Map<Long, Integer> map = new HashMap<Long, Integer>();
      for (int k = 0; k < batches.length; k++)
        map.put(batches[k].getBatchId(), k);

      List<NetworkClient.BatchItem> batches = Arrays.asList(this.batches);
      for (int k = 0; k < update.batches.length; k++) {
        long batch_id = update.getBatches()[k].getBatchId();
        if (map.containsKey(batch_id))
            batches.set(map.get(batch_id), update.batches[k]); else
            batches.add(update.batches[k]);
      }
      this.batches = batches.toArray(new NetworkClient.BatchItem[0]);
      next_revision = update.next_revision;
    }

    public void setBatches(NetworkClient.BatchItem[] value) {
      this.batches = value;
    }

    public NetworkClient.BatchItem[] getBatches() { return batches; }

    public void setNextRevision(long value) {
      this.next_revision = value;
    }

    public long getNextRevision() {
      return next_revision;
    }

  }

  static public class WorkerList {

    private NetworkClient.WorkerItem[] workers;
    private long next_revision;

    public void update(NetworkClient.WorkerList update) {
      Map<Long, Integer> map = new HashMap<Long, Integer>();
      for (int k = 0; k < workers.length; k++)
        map.put(workers[k].getWorkerId(), k);

      List<NetworkClient.WorkerItem> workers = Arrays.asList(this.workers);
      for (int k = 0; k < update.workers.length; k++) {
        long worker_id = update.getWorkers()[k].getWorkerId();
        if (map.containsKey(worker_id))
            workers.set(map.get(worker_id), update.workers[k]); else
            workers.add(update.workers[k]);
      }
      this.workers = workers.toArray(new NetworkClient.WorkerItem[0]);
      next_revision = update.next_revision;
    }

    public void setWorkers(NetworkClient.WorkerItem[] value) {
      this.workers = value;
    }

    public NetworkClient.WorkerItem[] getWorkers() { return workers; }

    public void setNextRevision(long value) {
      this.next_revision = value;
    }

    public long getNextRevision() {
      return next_revision;
    }

  }

  public NetworkClient() {
    this(MetashapeJNI.new_NetworkClient(), true);
  }

  /**
   * Connect to the server.<br>
   * @param host Server hostname.<br>
   * @param port Communication port.
   */
  public boolean connect(String host, int port) {
    return MetashapeJNI.NetworkClient_connect(swigCPtr, this, host, port);
  }

  /**
   * Disconnect from the server.
   */
  public void disconnect() {
    MetashapeJNI.NetworkClient_disconnect(swigCPtr, this);
  }

  /**
   * Create new batch.<br>
   * @param path Project path relative to root folder.<br>
   * @param tasks List of processing tasks to execute.<br>
   * @param meta Batch metadata.<br>
   * @return Batch id.
   */
  public int createBatch(String path, NetworkTask[] tasks, Map<String,String> meta) {
    return MetashapeJNI.NetworkClient_createBatch(swigCPtr, this, path, tasks, meta);
  }

  /**
   * Get batch id based on project path.<br>
   * @param path Project path relative to root folder.<br>
   * @return Batch id.
   */
  public int findBatch(String path) {
    return MetashapeJNI.NetworkClient_findBatch(swigCPtr, this, path);
  }

  /**
   * Abort batch.<br>
   * @param batch_id Batch id.
   */
  public void abortBatch(int batch_id) {
    MetashapeJNI.NetworkClient_abortBatch(swigCPtr, this, batch_id);
  }

  /**
   * Set batch paused state.<br>
   * @param batch_id Batch id.<br>
   * @param paused Paused state.
   */
  public void setBatchPaused(int batch_id, boolean paused) {
    MetashapeJNI.NetworkClient_setBatchPaused(swigCPtr, this, batch_id, paused);
  }

  /**
   * Set batch priority.<br>
   * @param batch_id Batch id.<br>
   * @param priority Batch priority (2 - Highest, 1 - High, 0 - Normal, -1 - Low, -2 - Lowest).
   */
  public void setBatchPriority(int batch_id, int priority) {
    MetashapeJNI.NetworkClient_setBatchPriority(swigCPtr, this, batch_id, priority);
  }

  /**
   * Set worker limit of the batch.<br>
   * @param batch_id Batch id.<br>
   * @param worker_limit Worker limit of the batch (0 - unlimited).
   */
  public void setBatchWorkerLimit(int batch_id, int worker_limit) {
    MetashapeJNI.NetworkClient_setBatchWorkerLimit(swigCPtr, this, batch_id, worker_limit);
  }

  /**
   * Abort worker.<br>
   * @param worker_id Worker id.
   */
  public void abortWorker(int worker_id) {
    MetashapeJNI.NetworkClient_abortWorker(swigCPtr, this, worker_id);
  }

  /**
   * Quit worker.<br>
   * @param worker_id Worker id.
   */
  public void quitWorker(int worker_id) {
    MetashapeJNI.NetworkClient_quitWorker(swigCPtr, this, worker_id);
  }

  /**
   * Set worker paused state.<br>
   * @param worker_id Worker id.<br>
   * @param paused Paused state.
   */
  public void setWorkerPaused(int worker_id, boolean paused) {
    MetashapeJNI.NetworkClient_setWorkerPaused(swigCPtr, this, worker_id, paused);
  }

  /**
   * Set worker priority.<br>
   * @param worker_id Worker id.<br>
   * @param priority Worker priority (2 - Highest, 1 - High, 0 - Normal, -1 - Low, -2 - Lowest).
   */
  public void setWorkerPriority(int worker_id, int priority) {
    MetashapeJNI.NetworkClient_setWorkerPriority(swigCPtr, this, worker_id, priority);
  }

  /**
   * Set worker capability.<br>
   * @param worker_id Worker id.<br>
   * @param capability Worker capability (1 - CPU, 2 - GPU, 3 - Any).
   */
  public void setWorkerCapability(int worker_id, int capability) {
    MetashapeJNI.NetworkClient_setWorkerCapability(swigCPtr, this, worker_id, capability);
  }

  /**
   * Set worker GPU mask.<br>
   * @param worker_id Worker id.<br>
   * @param gpu_mask GPU device mask.
   */
  public void setWorkerGpuMask(int worker_id, long gpu_mask) {
    MetashapeJNI.NetworkClient_setWorkerGpuMask(swigCPtr, this, worker_id, gpu_mask);
  }

  /**
   * Set worker CPU enabled flag.<br>
   * @param worker_id Worker id.<br>
   * @param cpu_enabled CPU enabled flag.
   */
  public void setWorkerCpuEnabled(int worker_id, boolean cpu_enabled) {
    MetashapeJNI.NetworkClient_setWorkerCpuEnabled(swigCPtr, this, worker_id, cpu_enabled);
  }

  /**
   * Get server version.
   */
  public NetworkClient.ServerVersion getServerVersion() { return MetashapeJNI.NetworkClient_getServerVersion(swigCPtr, this); }

  /**
   * Get server information.<br>
   * @param revision First revision to get.<br>
   * @return Server information.
   */
  public NetworkClient.ServerInfo getServerInfo(long revision) { return MetashapeJNI.NetworkClient_getServerInfo(swigCPtr, this, revision); }

  /**
   * Get batch information.<br>
   * @param batch_id Batch id.<br>
   * @param revision First revision to get.<br>
   * @return Batch information.
   */
  public NetworkClient.BatchInfo getBatchInfo(int batch_id, long revision) { return MetashapeJNI.NetworkClient_getBatchInfo(swigCPtr, this, batch_id, revision); }

  /**
   * Get worker information.<br>
   * @param worker_id Worker id.<br>
   * @param revision First revision to get.<br>
   * @return Worker information.
   */
  public NetworkClient.WorkerInfo getWorkerInfo(int worker_id, long revision) { return MetashapeJNI.NetworkClient_getWorkerInfo(swigCPtr, this, worker_id, revision); }

  /**
   * Get list of batches.<br>
   * @param revision First revision to get.<br>
   * @return List of batches.
   */
  public NetworkClient.BatchList getBatchList(long revision) { return MetashapeJNI.NetworkClient_getBatchList(swigCPtr, this, revision); }

  /**
   * Get list of workers.<br>
   * @param revision: First revision to get.<br>
   * @return List of workers.
   */
  public NetworkClient.WorkerList getWorkerList(long revision) { return MetashapeJNI.NetworkClient_getWorkerList(swigCPtr, this, revision); }

  /**
   * Export current state of batches.<br>
   * @param batch_ids Batch ids to export.<br>
   * @return Batches data.
   */
  public String exportBatches(int[] batch_ids) {
    return MetashapeJNI.NetworkClient_exportBatches(swigCPtr, this, batch_ids);
  }

  /**
   * Import batches from exported data.<br>
   * @param data Batches data.
   */
  public void importBatches(String data) {
    MetashapeJNI.NetworkClient_importBatches(swigCPtr, this, data);
  }

  public enum State {
    StatePending,
    StateInProgress,
    StateCompleted,
    StateReady,
    StateOffline;
  }

}
