package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class FilterPointCloud extends Task {

	public FilterPointCloud() {
		super("FilterPointCloud");
	}

	/**
	 *  Clip point cloud to chunk region.
	 */
	public void setClipToRegion(boolean value) {
		setParameter("clip_to_region", (Object) value);
	}

	/**
	 *  Clip point cloud to chunk region.
	 */
	public boolean getClipToRegion() {
		return (boolean) getParameter("clip_to_region");
	}

	/**
	 *  List of frames to process.
	 */
	public void setFrames(int[] value) {
		setParameter("frames", (Object) value);
	}

	/**
	 *  List of frames to process.
	 */
	public int[] getFrames() {
		return (int[]) getParameter("frames");
	}

	/**
	 *  Point cloud key to filter.
	 */
	public void setPointCloud(int value) {
		setParameter("point_cloud", (Object) value);
	}

	/**
	 *  Point cloud key to filter.
	 */
	public int getPointCloud() {
		return (int) getParameter("point_cloud");
	}

	/**
	 *  Desired point spacing (m). Default: 0.0
	 */
	public void setPointSpacing(double value) {
		setParameter("point_spacing", (Object) value);
	}

	/**
	 *  Desired point spacing (m). Default: 0.0
	 */
	public double getPointSpacing() {
		return (double) getParameter("point_spacing");
	}

	/**
	 *  Replace default asset with filtered point cloud.
	 */
	public void setReplaceAsset(boolean value) {
		setParameter("replace_asset", (Object) value);
	}

	/**
	 *  Replace default asset with filtered point cloud.
	 */
	public boolean getReplaceAsset() {
		return (boolean) getParameter("replace_asset");
	}

}
