package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class ImportTrajectory extends Task {

	public ImportTrajectory() {
		super("ImportTrajectory");
	}

	/**
	 *  Column order in csv format (t - time, x/y/z - coordinates, a/b/c - rotation angles, space - skip column).
	 */
	public void setColumns(String value) {
		setParameter("columns", (Object) value);
	}

	/**
	 *  Column order in csv format (t - time, x/y/z - coordinates, a/b/c - rotation angles, space - skip column).
	 */
	public String getColumns() {
		return (String) getParameter("columns");
	}

	/**
	 *  Point cloud coordinate system.
	 */
	public void setCRS(CoordinateSystem value) {
		setParameter("crs", (Object) value);
	}

	/**
	 *  Point cloud coordinate system.
	 */
	public CoordinateSystem getCRS() {
		return (CoordinateSystem) getParameter("crs");
	}

	/**
	 *  Column delimiter in csv format.
	 */
	public void setDelimiter(String value) {
		setParameter("delimiter", (Object) value);
	}

	/**
	 *  Column delimiter in csv format.
	 */
	public String getDelimiter() {
		return (String) getParameter("delimiter");
	}

	/**
	 *  Trajectory format. Default: TrajectoryFormat.TrajectoryFormatNone
	 */
	public void setFormat(TrajectoryFormat value) {
		setParameter("format", (Object) value);
	}

	/**
	 *  Trajectory format. Default: TrajectoryFormat.TrajectoryFormatNone
	 */
	public TrajectoryFormat getFormat() {
		return (TrajectoryFormat) getParameter("format");
	}

	/**
	 *  Combine consecutive delimiters in csv format.
	 */
	public void setGroupDelimiters(boolean value) {
		setParameter("group_delimiters", (Object) value);
	}

	/**
	 *  Combine consecutive delimiters in csv format.
	 */
	public boolean getGroupDelimiters() {
		return (boolean) getParameter("group_delimiters");
	}

	/**
	 *  Trajectory file path.
	 */
	public void setPath(String value) {
		setParameter("path", (Object) value);
	}

	/**
	 *  Trajectory file path.
	 */
	public String getPath() {
		return (String) getParameter("path");
	}

	/**
	 *  Replace default asset with imported trajectory.
	 */
	public void setReplaceAsset(boolean value) {
		setParameter("replace_asset", (Object) value);
	}

	/**
	 *  Replace default asset with imported trajectory.
	 */
	public boolean getReplaceAsset() {
		return (boolean) getParameter("replace_asset");
	}

	/**
	 *  Optional shift to be applied to point coordinates.
	 */
	public void setShift(Vector value) {
		setParameter("shift", (Object) value);
	}

	/**
	 *  Optional shift to be applied to point coordinates.
	 */
	public Vector getShift() {
		return (Vector) getParameter("shift");
	}

	/**
	 *  Number of rows to skip in (csv format only). Default: 0
	 */
	public void setSkipRows(int value) {
		setParameter("skip_rows", (Object) value);
	}

	/**
	 *  Number of rows to skip in (csv format only). Default: 0
	 */
	public int getSkipRows() {
		return (int) getParameter("skip_rows");
	}

}
