package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class ImportVideo extends Task {

	public ImportVideo() {
		super("ImportVideo");
	}

	/**
	 *  Every custom_frame_step'th frame will be saved. Used for frame_step=CustomFrameStep. Default: 1
	 */
	public void setCustomFrameStep(int value) {
		setParameter("custom_frame_step", (Object) value);
	}

	/**
	 *  Every custom_frame_step'th frame will be saved. Used for frame_step=CustomFrameStep. Default: 1
	 */
	public int getCustomFrameStep() {
		return (int) getParameter("custom_frame_step");
	}

	/**
	 *  Frame step type. Default: FrameStep.CustomFrameStep
	 */
	public void setFrameStep(FrameStep value) {
		setParameter("frame_step", (Object) value);
	}

	/**
	 *  Frame step type. Default: FrameStep.CustomFrameStep
	 */
	public FrameStep getFrameStep() {
		return (FrameStep) getParameter("frame_step");
	}

	/**
	 *  Path to directory where to save frames with filename template. For example: /path/to/dir/frame{filenum}.png.
	 */
	public void setImagePath(String value) {
		setParameter("image_path", (Object) value);
	}

	/**
	 *  Path to directory where to save frames with filename template. For example: /path/to/dir/frame{filenum}.png.
	 */
	public String getImagePath() {
		return (String) getParameter("image_path");
	}

	/**
	 *  Path to source video.
	 */
	public void setPath(String value) {
		setParameter("path", (Object) value);
	}

	/**
	 *  Path to source video.
	 */
	public String getPath() {
		return (String) getParameter("path");
	}

	/**
	 *  The endpoint for importing video, seconds. Default: -1.0
	 */
	public void setTimeEnd(double value) {
		setParameter("time_end", (Object) value);
	}

	/**
	 *  The endpoint for importing video, seconds. Default: -1.0
	 */
	public double getTimeEnd() {
		return (double) getParameter("time_end");
	}

	/**
	 *  The starting point for importing video, seconds. Default: 0.0
	 */
	public void setTimeStart(double value) {
		setParameter("time_start", (Object) value);
	}

	/**
	 *  The starting point for importing video, seconds. Default: 0.0
	 */
	public double getTimeStart() {
		return (double) getParameter("time_start");
	}

}
