package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class MergeAssets extends Task {

	public MergeAssets() {
		super("MergeAssets");
	}

	/**
	 *  Apply boresight offset when merging point clouds.
	 */
	public void setApplyBoresightOffset(boolean value) {
		setParameter("apply_boresight_offset", (Object) value);
	}

	/**
	 *  Apply boresight offset when merging point clouds.
	 */
	public boolean getApplyBoresightOffset() {
		return (boolean) getParameter("apply_boresight_offset");
	}

	/**
	 *  Apply trajectory mask when merging point clouds.
	 */
	public void setApplyTrajectoryMask(boolean value) {
		setParameter("apply_trajectory_mask", (Object) value);
	}

	/**
	 *  Apply trajectory mask when merging point clouds.
	 */
	public boolean getApplyTrajectoryMask() {
		return (boolean) getParameter("apply_trajectory_mask");
	}

	/**
	 *  List of assets to process.
	 */
	public void setAssets(int[] value) {
		setParameter("assets", (Object) value);
	}

	/**
	 *  List of assets to process.
	 */
	public int[] getAssets() {
		return (int[]) getParameter("assets");
	}

	/**
	 *  Merge orthophotos when merging orthomosaics.
	 */
	public void setMergeOrthophotos(boolean value) {
		setParameter("merge_orthophotos", (Object) value);
	}

	/**
	 *  Merge orthophotos when merging orthomosaics.
	 */
	public boolean getMergeOrthophotos() {
		return (boolean) getParameter("merge_orthophotos");
	}

	/**
	 *  Asset type. Default: DataSource.PointCloudData
	 */
	public void setSourceData(DataSource value) {
		setParameter("source_data", (Object) value);
	}

	/**
	 *  Asset type. Default: DataSource.PointCloudData
	 */
	public DataSource getSourceData() {
		return (DataSource) getParameter("source_data");
	}

}
