package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class SmoothModel extends Task {

	public SmoothModel() {
		super("SmoothModel");
	}

	/**
	 *  Apply to selected faces.
	 */
	public void setApplyToSelection(boolean value) {
		setParameter("apply_to_selection", (Object) value);
	}

	/**
	 *  Apply to selected faces.
	 */
	public boolean getApplyToSelection() {
		return (boolean) getParameter("apply_to_selection");
	}

	/**
	 *  Fix borders.
	 */
	public void setFixBorders(boolean value) {
		setParameter("fix_borders", (Object) value);
	}

	/**
	 *  Fix borders.
	 */
	public boolean getFixBorders() {
		return (boolean) getParameter("fix_borders");
	}

	/**
	 *  List of frames to process.
	 */
	public void setFrames(int[] value) {
		setParameter("frames", (Object) value);
	}

	/**
	 *  List of frames to process.
	 */
	public int[] getFrames() {
		return (int[]) getParameter("frames");
	}

	/**
	 *  Key of model to smooth.
	 */
	public void setModel(int value) {
		setParameter("model", (Object) value);
	}

	/**
	 *  Key of model to smooth.
	 */
	public int getModel() {
		return (int) getParameter("model");
	}

	/**
	 *  Preserve edges.
	 */
	public void setPreserveEdges(boolean value) {
		setParameter("preserve_edges", (Object) value);
	}

	/**
	 *  Preserve edges.
	 */
	public boolean getPreserveEdges() {
		return (boolean) getParameter("preserve_edges");
	}

	/**
	 *  Replace default asset with smoothed model.
	 */
	public void setReplaceAsset(boolean value) {
		setParameter("replace_asset", (Object) value);
	}

	/**
	 *  Replace default asset with smoothed model.
	 */
	public boolean getReplaceAsset() {
		return (boolean) getParameter("replace_asset");
	}

	/**
	 *  Smoothing strength. Default: 3.0
	 */
	public void setStrength(double value) {
		setParameter("strength", (Object) value);
	}

	/**
	 *  Smoothing strength. Default: 3.0
	 */
	public double getStrength() {
		return (double) getParameter("strength");
	}

}
