package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class SmoothPointCloud extends Task {

	public SmoothPointCloud() {
		super("SmoothPointCloud");
	}

	/**
	 *  Smooth points within selection.
	 */
	public void setApplyToSelection(boolean value) {
		setParameter("apply_to_selection", (Object) value);
	}

	/**
	 *  Smooth points within selection.
	 */
	public boolean getApplyToSelection() {
		return (boolean) getParameter("apply_to_selection");
	}

	/**
	 *  List of point classes to be smoothed.
	 */
	public void setClasses(int[] value) {
		setParameter("classes", (Object) value);
	}

	/**
	 *  List of point classes to be smoothed.
	 */
	public int[] getClasses() {
		return (int[]) getParameter("classes");
	}

	/**
	 *  Clip point cloud to chunk region.
	 */
	public void setClipToRegion(boolean value) {
		setParameter("clip_to_region", (Object) value);
	}

	/**
	 *  Clip point cloud to chunk region.
	 */
	public boolean getClipToRegion() {
		return (boolean) getParameter("clip_to_region");
	}

	/**
	 *  List of frames to process.
	 */
	public void setFrames(int[] value) {
		setParameter("frames", (Object) value);
	}

	/**
	 *  List of frames to process.
	 */
	public int[] getFrames() {
		return (int[]) getParameter("frames");
	}

	/**
	 *  Key of point cloud to filter.
	 */
	public void setPointCloud(int value) {
		setParameter("point_cloud", (Object) value);
	}

	/**
	 *  Key of point cloud to filter.
	 */
	public int getPointCloud() {
		return (int) getParameter("point_cloud");
	}

	/**
	 *  Replace default asset with smoothed point cloud.
	 */
	public void setReplaceAsset(boolean value) {
		setParameter("replace_asset", (Object) value);
	}

	/**
	 *  Replace default asset with smoothed point cloud.
	 */
	public boolean getReplaceAsset() {
		return (boolean) getParameter("replace_asset");
	}

	/**
	 *  Desired smoothing radius (m). Default: 0.0
	 */
	public void setSmoothingRadius(double value) {
		setParameter("smoothing_radius", (Object) value);
	}

	/**
	 *  Desired smoothing radius (m). Default: 0.0
	 */
	public double getSmoothingRadius() {
		return (double) getParameter("smoothing_radius");
	}

}
