/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.Chunk;
import com.agisoft.metashape.MetashapeJNI;
import java.util.Map;
import java.util.Optional;

public class CameraTrack
implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected CameraTrack(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(CameraTrack cameraTrack) {
        return cameraTrack == null ? 0L : cameraTrack.swigCPtr;
    }

    protected static long swigRelease(CameraTrack cameraTrack) {
        long l = 0L;
        if (cameraTrack != null) {
            if (!cameraTrack.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = cameraTrack.swigCPtr;
            cameraTrack.swigCMemOwn = false;
            cameraTrack.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_CameraTrack(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public CameraTrack(CameraTrack cameraTrack) {
        this(MetashapeJNI.new_CameraTrack(CameraTrack.getCPtr(cameraTrack), cameraTrack), true);
    }

    public void setLabel(String string) {
        MetashapeJNI.CameraTrack_setLabel(this.swigCPtr, this, string);
    }

    public String getLabel() {
        return MetashapeJNI.CameraTrack_getLabel(this.swigCPtr, this);
    }

    public void setSelected(boolean bl) {
        MetashapeJNI.CameraTrack_setSelected(this.swigCPtr, this, bl);
    }

    public boolean isSelected() {
        return MetashapeJNI.CameraTrack_isSelected(this.swigCPtr, this);
    }

    public void setDuration(double d) {
        MetashapeJNI.CameraTrack_setDuration(this.swigCPtr, this, d);
    }

    public double getDuration() {
        return MetashapeJNI.CameraTrack_getDuration(this.swigCPtr, this);
    }

    public void setFieldOfView(double d) {
        MetashapeJNI.CameraTrack_setFieldOfView(this.swigCPtr, this, d);
    }

    public double getFieldOfView() {
        return MetashapeJNI.CameraTrack_getFieldOfView(this.swigCPtr, this);
    }

    public void setKeyframes(int[] nArray) {
        MetashapeJNI.CameraTrack_setKeyframes(this.swigCPtr, this, nArray);
    }

    public int[] getKeyframes() {
        return MetashapeJNI.CameraTrack_getKeyframes(this.swigCPtr, this);
    }

    public int getKey() {
        return MetashapeJNI.CameraTrack_getKey(this.swigCPtr, this);
    }

    public Optional<Chunk> getChunk() {
        long l = MetashapeJNI.CameraTrack_getChunk(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Chunk(l, true));
    }

    public void setMeta(Map<String, String> map) {
        MetashapeJNI.CameraTrack_setMeta(this.swigCPtr, this, map);
    }

    public Map<String, String> getMeta() {
        return MetashapeJNI.CameraTrack_getMeta(this.swigCPtr, this);
    }
}

