/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.Chunk;
import com.agisoft.metashape.Image;
import com.agisoft.metashape.MetashapeJNI;
import java.util.Map;
import java.util.Optional;

public class Masks
implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Masks(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Masks masks) {
        return masks == null ? 0L : masks.swigCPtr;
    }

    protected static long swigRelease(Masks masks) {
        long l = 0L;
        if (masks != null) {
            if (!masks.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = masks.swigCPtr;
            masks.swigCMemOwn = false;
            masks.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_Masks(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public Masks(Masks masks) {
        this(MetashapeJNI.new_Masks(Masks.getCPtr(masks), masks), true);
    }

    public int getKey() {
        return MetashapeJNI.Masks_getKey(this.swigCPtr, this);
    }

    public Optional<Chunk> getChunk() {
        long l = MetashapeJNI.Masks_getChunk(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Chunk(l, true));
    }

    public void setLabel(String string) {
        MetashapeJNI.Masks_setLabel(this.swigCPtr, this, string);
    }

    public String getLabel() {
        return MetashapeJNI.Masks_getLabel(this.swigCPtr, this);
    }

    public void setMask(int n, Image image) {
        MetashapeJNI.Masks_setMask(this.swigCPtr, this, n, image == null ? 0L : Image.getCPtr(image), image);
    }

    public Optional<Image> getMask(int n) {
        long l = MetashapeJNI.Masks_getMask(this.swigCPtr, this, n);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Image(l, true));
    }

    public String getPath() {
        return MetashapeJNI.Masks_getPath(this.swigCPtr, this);
    }

    public void setMeta(Map<String, String> map) {
        MetashapeJNI.Masks_setMeta(this.swigCPtr, this, map);
    }

    public Map<String, String> getMeta() {
        return MetashapeJNI.Masks_getMeta(this.swigCPtr, this);
    }
}

