/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.Chunk;
import com.agisoft.metashape.CoordinateSystem;
import com.agisoft.metashape.MetashapeJNI;
import com.agisoft.metashape.OrthoProjection;
import com.agisoft.metashape.Shape;
import com.agisoft.metashape.ShapeGroup;
import com.agisoft.metashape.SwigHelpers;
import java.util.Map;
import java.util.Optional;

public class Shapes
implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Shapes(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Shapes shapes) {
        return shapes == null ? 0L : shapes.swigCPtr;
    }

    protected static long swigRelease(Shapes shapes) {
        long l = 0L;
        if (shapes != null) {
            if (!shapes.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = shapes.swigCPtr;
            shapes.swigCMemOwn = false;
            shapes.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_Shapes(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public Shapes() {
        this(MetashapeJNI.new_Shapes__SWIG_0(), true);
    }

    public Shapes(Shapes shapes) {
        this(MetashapeJNI.new_Shapes__SWIG_1(Shapes.getCPtr(shapes), shapes), true);
    }

    public Optional<Chunk> getChunk() {
        long l = MetashapeJNI.Shapes_getChunk(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Chunk(l, true));
    }

    public String getPath() {
        return MetashapeJNI.Shapes_getPath(this.swigCPtr, this);
    }

    public void setMeta(Map<String, String> map) {
        MetashapeJNI.Shapes_setMeta(this.swigCPtr, this, map);
    }

    public Map<String, String> getMeta() {
        return MetashapeJNI.Shapes_getMeta(this.swigCPtr, this);
    }

    public Shape[] getShapes() {
        return SwigHelpers.cArrayWrap(MetashapeJNI.Shapes_getShapes(this.swigCPtr, this), true, Shape.class);
    }

    public ShapeGroup[] getGroups() {
        return SwigHelpers.cArrayWrap(MetashapeJNI.Shapes_getGroups(this.swigCPtr, this), true, ShapeGroup.class);
    }

    public void setProjection(OrthoProjection orthoProjection) {
        MetashapeJNI.Shapes_setProjection(this.swigCPtr, this, OrthoProjection.getCPtr(orthoProjection), orthoProjection);
    }

    public OrthoProjection getProjection() {
        return new OrthoProjection(MetashapeJNI.Shapes_getProjection(this.swigCPtr, this), true);
    }

    public void setCoordinateSystem(CoordinateSystem coordinateSystem) {
        MetashapeJNI.Shapes_setCoordinateSystem(this.swigCPtr, this, CoordinateSystem.getCPtr(coordinateSystem), coordinateSystem);
    }

    public CoordinateSystem getCoordinateSystem() {
        return new CoordinateSystem(MetashapeJNI.Shapes_getCoordinateSystem(this.swigCPtr, this), true);
    }
}

