/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.Antenna;
import com.agisoft.metashape.Chunk;
import com.agisoft.metashape.CoordinateSystem;
import com.agisoft.metashape.Matrix;
import com.agisoft.metashape.MetashapeJNI;
import java.util.Map;
import java.util.Optional;

public class Trajectory
implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Trajectory(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Trajectory trajectory) {
        return trajectory == null ? 0L : trajectory.swigCPtr;
    }

    protected static long swigRelease(Trajectory trajectory) {
        long l = 0L;
        if (trajectory != null) {
            if (!trajectory.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = trajectory.swigCPtr;
            trajectory.swigCMemOwn = false;
            trajectory.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_Trajectory(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public Trajectory(Trajectory trajectory) {
        this(MetashapeJNI.new_Trajectory(Trajectory.getCPtr(trajectory), trajectory), true);
    }

    public int getKey() {
        return MetashapeJNI.Trajectory_getKey(this.swigCPtr, this);
    }

    public Optional<Chunk> getChunk() {
        long l = MetashapeJNI.Trajectory_getChunk(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Chunk(l, true));
    }

    public void setLabel(String string) {
        MetashapeJNI.Trajectory_setLabel(this.swigCPtr, this, string);
    }

    public String getLabel() {
        return MetashapeJNI.Trajectory_getLabel(this.swigCPtr, this);
    }

    public void setSelected(boolean bl) {
        MetashapeJNI.Trajectory_setSelected(this.swigCPtr, this, bl);
    }

    public boolean isSelected() {
        return MetashapeJNI.Trajectory_isSelected(this.swigCPtr, this);
    }

    public String getPath() {
        return MetashapeJNI.Trajectory_getPath(this.swigCPtr, this);
    }

    public long getPositionCount() {
        return MetashapeJNI.Trajectory_getPositionCount(this.swigCPtr, this);
    }

    public void setAntenna(Antenna antenna) {
        MetashapeJNI.Trajectory_setAntenna(this.swigCPtr, this, antenna);
    }

    public Antenna getAntenna() {
        return MetashapeJNI.Trajectory_getAntenna(this.swigCPtr, this);
    }

    public void setMeta(Map<String, String> map) {
        MetashapeJNI.Trajectory_setMeta(this.swigCPtr, this, map);
    }

    public Map<String, String> getMeta() {
        return MetashapeJNI.Trajectory_getMeta(this.swigCPtr, this);
    }

    public void setTransform(Matrix matrix) {
        MetashapeJNI.Trajectory_setTransform(this.swigCPtr, this, matrix);
    }

    public Matrix getTransform() {
        return MetashapeJNI.Trajectory_getTransform(this.swigCPtr, this);
    }

    public void setCoordinateSystem(CoordinateSystem coordinateSystem) {
        MetashapeJNI.Trajectory_setCoordinateSystem(this.swigCPtr, this, coordinateSystem == null ? 0L : CoordinateSystem.getCPtr(coordinateSystem), coordinateSystem);
    }

    public Optional<CoordinateSystem> getCoordinateSystem() {
        long l = MetashapeJNI.Trajectory_getCoordinateSystem(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new CoordinateSystem(l, true));
    }
}

