/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

import java.lang.AutoCloseable;
import java.util.Optional;
import java.util.Map;

/**
 * ScalebarGroup objects define groups of multiple scale bars. The grouping is established by<br>
 * assignment of a ScalebarGroup instance to the Scalebar.group attribute of participating scale bars.
 */
public class ScalebarGroup implements AutoCloseable {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected ScalebarGroup(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ScalebarGroup obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ScalebarGroup obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_ScalebarGroup(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  @Override
  public void close() {
    delete();
  }

  public ScalebarGroup(ScalebarGroup scalebar_group) {
    this(MetashapeJNI.new_ScalebarGroup(ScalebarGroup.getCPtr(scalebar_group), scalebar_group), true);
  }

  /**
   *  Scale bar group key.
   */
  public int getKey() {
    return MetashapeJNI.ScalebarGroup_getKey(swigCPtr, this);
  }

  /**
   *  Chunk container, may be null.
   */
  public Optional<Chunk> getChunk() {
    long ptr = MetashapeJNI.ScalebarGroup_getChunk(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Chunk(ptr, true));
  }

  /**
   *  Scale bar group label.
   */
  public void setLabel(String label) {
    MetashapeJNI.ScalebarGroup_setLabel(swigCPtr, this, label);
  }

  /**
   *  Scale bar group label.
   */
  public String getLabel() {
    return MetashapeJNI.ScalebarGroup_getLabel(swigCPtr, this);
  }

  /**
   *  Current selection state.
   */
  public void setSelected(boolean state) {
    MetashapeJNI.ScalebarGroup_setSelected(swigCPtr, this, state);
  }

  /**
   *  Current selection state.
   */
  public boolean isSelected() {
    return MetashapeJNI.ScalebarGroup_isSelected(swigCPtr, this);
  }

}
