/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

import java.lang.AutoCloseable;
import java.util.Optional;
import java.util.Map;

/**
 * Tie point cloud.
 */
public class TiePoints implements AutoCloseable {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected TiePoints(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(TiePoints obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(TiePoints obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_TiePoints(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  @Override
  public void close() {
    delete();
  }

  static public class Track {

    private Color color;

    public Track() {
      color = new Color();
    }

    public void setColor(Color value) {
      this.color = value;
    }

    public Color getColor() {
      return color;
    }

  }

  static public class Point {

    private Vector coord;
    private long track_id;
    private boolean selected;
    private boolean valid;

    public Point() {
      coord = new Vector(0, 0, 0);
      track_id = 0;
      selected = false;
      valid = true;
    }

    public void setCoord(Vector coord) {
      this.coord = coord;
    }

    public Vector getCoord() { return coord; }

    public void setValid(boolean on) {
      this.valid = on;
    }

    public boolean isValid() {
      return valid;
    }

    public void setSelected(boolean on) {
      this.selected = on;
    }

    public boolean isSelected() {
      return selected;
    }

    public void setTrackId(long track_id) {
      this.track_id = track_id;
    }

    public long getTrackId() {
      return track_id;
    }

  }

  static public class Projection {

    private Vector coord;
    private float size;
    private long track_id;

    public Projection() {
      coord = new Vector(0, 0);
      size = 1;
      track_id = 0;
    }

    public void setCoord(Vector coord) {
      this.coord = coord;
    }

    public Vector getCoord() { return coord; }

    public void setSize(float size) {
      this.size = size;
    }

    public float getSize() {
      return size;
    }

    public void setTrackId(long track_id) {
      this.track_id = track_id;
    }

    public long getTrackId() {
      return track_id;
    }

  }

  public TiePoints() {
    this(MetashapeJNI.new_TiePoints__SWIG_0(), true);
  }

  public TiePoints(TiePoints tie_points) {
    this(MetashapeJNI.new_TiePoints__SWIG_1(TiePoints.getCPtr(tie_points), tie_points), true);
  }

  static public class Tracks implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    protected Tracks(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    protected static long getCPtr(Tracks obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    protected static long swigRelease(Tracks obj) {
      long ptr = 0;
      if (obj != null) {
        if (!obj.swigCMemOwn)
          throw new RuntimeException("Cannot release ownership as memory is not owned");
        ptr = obj.swigCPtr;
        obj.swigCMemOwn = false;
        obj.delete();
      }
      return ptr;
    }
  
    @SuppressWarnings({"deprecation", "removal"})
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          MetashapeJNI.delete_TiePoints_Tracks(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
    @Override
    public void close() {
      delete();
    }
  
    public Tracks() {
      this(MetashapeJNI.new_TiePoints_Tracks__SWIG_0(), true);
    }
  
    public Tracks(TiePoints.Tracks tracks) {
      this(MetashapeJNI.new_TiePoints_Tracks__SWIG_1(TiePoints.Tracks.getCPtr(tracks), tracks), true);
    }
  
    public TiePoints.Tracks copy() {
      return new TiePoints.Tracks(MetashapeJNI.TiePoints_Tracks_copy(swigCPtr, this), true);
    }
  
    public void resize(long size) {
      MetashapeJNI.TiePoints_Tracks_resize(swigCPtr, this, size);
    }
  
    public long getSize() {
      return MetashapeJNI.TiePoints_Tracks_getSize(swigCPtr, this);
    }
  
    public void set(long index, TiePoints.Track track) {
      MetashapeJNI.TiePoints_Tracks_set(swigCPtr, this, index, track);
    }
  
    public TiePoints.Track get(long index) { return MetashapeJNI.TiePoints_Tracks_get(swigCPtr, this, index); }
  
  }

  static public class Points implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    protected Points(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    protected static long getCPtr(Points obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    protected static long swigRelease(Points obj) {
      long ptr = 0;
      if (obj != null) {
        if (!obj.swigCMemOwn)
          throw new RuntimeException("Cannot release ownership as memory is not owned");
        ptr = obj.swigCPtr;
        obj.swigCMemOwn = false;
        obj.delete();
      }
      return ptr;
    }
  
    @SuppressWarnings({"deprecation", "removal"})
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          MetashapeJNI.delete_TiePoints_Points(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
    @Override
    public void close() {
      delete();
    }
  
    public Points() {
      this(MetashapeJNI.new_TiePoints_Points__SWIG_0(), true);
    }
  
    public Points(TiePoints.Points points) {
      this(MetashapeJNI.new_TiePoints_Points__SWIG_1(TiePoints.Points.getCPtr(points), points), true);
    }
  
    public TiePoints.Points copy() {
      return new TiePoints.Points(MetashapeJNI.TiePoints_Points_copy(swigCPtr, this), true);
    }
  
    public void resize(long size) {
      MetashapeJNI.TiePoints_Points_resize(swigCPtr, this, size);
    }
  
    public long getSize() {
      return MetashapeJNI.TiePoints_Points_getSize(swigCPtr, this);
    }
  
    public void set(long index, TiePoints.Point point) {
      MetashapeJNI.TiePoints_Points_set(swigCPtr, this, index, point);
    }
  
    public TiePoints.Point get(long index) { return MetashapeJNI.TiePoints_Points_get(swigCPtr, this, index); }
  
  }

  static public class Projections implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    protected Projections(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    protected static long getCPtr(Projections obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    protected static long swigRelease(Projections obj) {
      long ptr = 0;
      if (obj != null) {
        if (!obj.swigCMemOwn)
          throw new RuntimeException("Cannot release ownership as memory is not owned");
        ptr = obj.swigCPtr;
        obj.swigCMemOwn = false;
        obj.delete();
      }
      return ptr;
    }
  
    @SuppressWarnings({"deprecation", "removal"})
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          MetashapeJNI.delete_TiePoints_Projections(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
    @Override
    public void close() {
      delete();
    }
  
    public Projections() {
      this(MetashapeJNI.new_TiePoints_Projections__SWIG_0(), true);
    }
  
    public Projections(TiePoints.Projections projections) {
      this(MetashapeJNI.new_TiePoints_Projections__SWIG_1(TiePoints.Projections.getCPtr(projections), projections), true);
    }
  
    public TiePoints.Projections copy() {
      return new TiePoints.Projections(MetashapeJNI.TiePoints_Projections_copy(swigCPtr, this), true);
    }
  
    public void resize(long size) {
      MetashapeJNI.TiePoints_Projections_resize(swigCPtr, this, size);
    }
  
    public long getSize() {
      return MetashapeJNI.TiePoints_Projections_getSize(swigCPtr, this);
    }
  
    public void set(long index, TiePoints.Projection proj) {
      MetashapeJNI.TiePoints_Projections_set(swigCPtr, this, index, proj);
    }
  
    public TiePoints.Projection get(long index) { return MetashapeJNI.TiePoints_Projections_get(swigCPtr, this, index); }
  
  }

  /**
   *  Chunk container, may be null.
   */
  public Optional<Chunk> getChunk() {
    long ptr = MetashapeJNI.TiePoints_getChunk(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Chunk(ptr, true));
  }

  /**
   *  Path to tie points file.
   */
  public String getPath() {
    return MetashapeJNI.TiePoints_getPath(swigCPtr, this);
  }

  /**
   *  Tie points meta data.
   */
  public void setMeta(Map<String,String> meta) {
    MetashapeJNI.TiePoints_setMeta(swigCPtr, this, meta);
  }

  /**
   *  Tie points meta data.
   */
  public Map<String,String> getMeta() { return MetashapeJNI.TiePoints_getMeta(swigCPtr, this); }

  /**
   *  List of tracks, may be null.
   */
  public void setTracks(TiePoints.Tracks tracks) {
    MetashapeJNI.TiePoints_setTracks(swigCPtr, this, tracks == null ? 0 : TiePoints.Tracks.getCPtr(tracks));
  }

  /**
   *  List of tracks, may be null.
   */
  public Optional<TiePoints.Tracks> getTracks() {
    long ptr = MetashapeJNI.TiePoints_getTracks(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new TiePoints.Tracks(ptr, true));
  }

  /**
   *  List of points, may be null.
   */
  public void setPoints(TiePoints.Points points) {
    MetashapeJNI.TiePoints_setPoints(swigCPtr, this, points == null ? 0 : TiePoints.Points.getCPtr(points));
  }

  /**
   *  List of points, may be null.
   */
  public Optional<TiePoints.Points> getPoints() {
    long ptr = MetashapeJNI.TiePoints_getPoints(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new TiePoints.Points(ptr, true));
  }

  /**
   *  Point projections for the camera, may be null.
   */
  public void setProjections(int camera, TiePoints.Projections projections) {
    MetashapeJNI.TiePoints_setProjections(swigCPtr, this, camera, projections == null ? 0 : TiePoints.Projections.getCPtr(projections));
  }

  /**
   *  Point projections for the camera, may be null.
   */
  public Optional<TiePoints.Projections> getProjections(int camera) {
    long ptr = MetashapeJNI.TiePoints_getProjections(swigCPtr, this, camera);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new TiePoints.Projections(ptr, true));
  }

  public int[] getCameraKeys() { return MetashapeJNI.TiePoints_getCameraKeys(swigCPtr, this); }

  /**
   * Remove points with insufficient number of projections.<br>
   * @param progress Progress callback.
   */
  public void cleanup(Progress progress) {
    MetashapeJNI.TiePoints_cleanup(swigCPtr, this, progress);
  }

  /**
   * Returns ray intersection with the tie point cloud.<br>
   * @param origin Ray origin.<br>
   * @param target Point on the ray.<br>
   * @return Coordinates of the intersection point, may be null.
   */
  public Optional<Vector> pickPoint(Vector origin, Vector target) {
	Vector values = MetashapeJNI.TiePoints_pickPoint(swigCPtr, this, origin, target);
	return values == null ? Optional.empty() : Optional.of(values); }

  /**
   * Generate tie points preview image.<br>
   * @param width Preview image width.<br>
   * @param height Preview image height.<br>
   * @param transform 4x4 viewpoint transformation matrix.<br>
   * @param point_size Point size.<br>
   * @return Preview image.
   */
  public Image renderPreview(long width, long height, Matrix transform, int point_size, Progress progress) {
    return new Image(MetashapeJNI.TiePoints_renderPreview(swigCPtr, this, width, height, transform, point_size, progress), true);
  }

  public enum Criterion {
    ReprojectionError,
    ReconstructionUncertainty,
    ImageCount,
    ProjectionAccuracy;
  }

}
