package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class BuildTexture extends Task {

	public BuildTexture() {
		super("BuildTexture");
	}

	/**
	 *  Anti-aliasing coefficient for baking Default: 1
	 */
	public void setAntiAliasing(int value) {
		setParameter("anti_aliasing", (Object) value);
	}

	/**
	 *  Anti-aliasing coefficient for baking Default: 1
	 */
	public int getAntiAliasing() {
		return (int) getParameter("anti_aliasing");
	}

	/**
	 *  Texture blending mode. Default: BlendingMode.NaturalBlending
	 */
	public void setBlendingMode(BlendingMode value) {
		setParameter("blending_mode", (Object) value);
	}

	/**
	 *  Texture blending mode. Default: BlendingMode.NaturalBlending
	 */
	public BlendingMode getBlendingMode() {
		return (BlendingMode) getParameter("blending_mode");
	}

	/**
	 *  A list of cameras to be used for texturing.
	 */
	public void setCameras(int[] value) {
		setParameter("cameras", (Object) value);
	}

	/**
	 *  A list of cameras to be used for texturing.
	 */
	public int[] getCameras() {
		return (int[]) getParameter("cameras");
	}

	/**
	 *  Images downscale (natural blending only). Default: 2
	 */
	public void setDownscale(int value) {
		setParameter("downscale", (Object) value);
	}

	/**
	 *  Images downscale (natural blending only). Default: 2
	 */
	public int getDownscale() {
		return (int) getParameter("downscale");
	}

	/**
	 *  Enable hole filling.
	 */
	public void setFillHoles(boolean value) {
		setParameter("fill_holes", (Object) value);
	}

	/**
	 *  Enable hole filling.
	 */
	public boolean getFillHoles() {
		return (boolean) getParameter("fill_holes");
	}

	/**
	 *  Enable ghosting filter.
	 */
	public void setGhostingFilter(boolean value) {
		setParameter("ghosting_filter", (Object) value);
	}

	/**
	 *  Enable ghosting filter.
	 */
	public boolean getGhostingFilter() {
		return (boolean) getParameter("ghosting_filter");
	}

	/**
	 *  Maximum workgroup size (block model only). Default: 100
	 */
	public void setMaxWorkgroupSize(int value) {
		setParameter("max_workgroup_size", (Object) value);
	}

	/**
	 *  Maximum workgroup size (block model only). Default: 100
	 */
	public int getMaxWorkgroupSize() {
		return (int) getParameter("max_workgroup_size");
	}

	/**
	 *  Enable out-of-focus filter (natural blending only).
	 */
	public void setOutOfFocusFilter(boolean value) {
		setParameter("out_of_focus_filter", (Object) value);
	}

	/**
	 *  Enable out-of-focus filter (natural blending only).
	 */
	public boolean getOutOfFocusFilter() {
		return (boolean) getParameter("out_of_focus_filter");
	}

	/**
	 *  Sharpening strength (natural blending only). Default: 1.0
	 */
	public void setSharpening(double value) {
		setParameter("sharpening", (Object) value);
	}

	/**
	 *  Sharpening strength (natural blending only). Default: 1.0
	 */
	public double getSharpening() {
		return (double) getParameter("sharpening");
	}

	/**
	 *  Source asset.
	 */
	public void setSourceAsset(int value) {
		setParameter("source_asset", (Object) value);
	}

	/**
	 *  Source asset.
	 */
	public int getSourceAsset() {
		return (int) getParameter("source_asset");
	}

	/**
	 *  Source data to create texture from. Default: DataSource.ImagesData
	 */
	public void setSourceData(DataSource value) {
		setParameter("source_data", (Object) value);
	}

	/**
	 *  Source data to create texture from. Default: DataSource.ImagesData
	 */
	public DataSource getSourceData() {
		return (DataSource) getParameter("source_data");
	}

	/**
	 *  Texture page size. Default: 8192
	 */
	public void setTextureSize(int value) {
		setParameter("texture_size", (Object) value);
	}

	/**
	 *  Texture page size. Default: 8192
	 */
	public int getTextureSize() {
		return (int) getParameter("texture_size");
	}

	/**
	 *  Texture type. Default: Model.TextureType.DiffuseMap
	 */
	public void setTextureType(Model.TextureType value) {
		setParameter("texture_type", (Object) value);
	}

	/**
	 *  Texture type. Default: Model.TextureType.DiffuseMap
	 */
	public Model.TextureType getTextureType() {
		return (Model.TextureType) getParameter("texture_type");
	}

	/**
	 *  Transfer texture.
	 */
	public void setTransferTexture(boolean value) {
		setParameter("transfer_texture", (Object) value);
	}

	/**
	 *  Transfer texture.
	 */
	public boolean getTransferTexture() {
		return (boolean) getParameter("transfer_texture");
	}

	/**
	 *  Use assigned images when blending.
	 */
	public void setUseAssignedImages(boolean value) {
		setParameter("use_assigned_images", (Object) value);
	}

	/**
	 *  Use assigned images when blending.
	 */
	public boolean getUseAssignedImages() {
		return (boolean) getParameter("use_assigned_images");
	}

	/**
	 *  Number of cameras in a workitem (block model only). Default: 20
	 */
	public void setWorkitemSizeCameras(int value) {
		setParameter("workitem_size_cameras", (Object) value);
	}

	/**
	 *  Number of cameras in a workitem (block model only). Default: 20
	 */
	public int getWorkitemSizeCameras() {
		return (int) getParameter("workitem_size_cameras");
	}

}
