package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class DuplicateAsset extends Task {

	public DuplicateAsset() {
		super("DuplicateAsset");
	}

	/**
	 *  Asset key.
	 */
	public void setAssetKey(int value) {
		setParameter("asset_key", (Object) value);
	}

	/**
	 *  Asset key.
	 */
	public int getAssetKey() {
		return (int) getParameter("asset_key");
	}

	/**
	 *  Asset type. Default: DataSource.ModelData
	 */
	public void setAssetType(DataSource value) {
		setParameter("asset_type", (Object) value);
	}

	/**
	 *  Asset type. Default: DataSource.ModelData
	 */
	public DataSource getAssetType() {
		return (DataSource) getParameter("asset_type");
	}

	/**
	 *  Clip to boundary shapes.
	 */
	public void setClipToBoundary(boolean value) {
		setParameter("clip_to_boundary", (Object) value);
	}

	/**
	 *  Clip to boundary shapes.
	 */
	public boolean getClipToBoundary() {
		return (boolean) getParameter("clip_to_boundary");
	}

	/**
	 *  Clip to chunk region.
	 */
	public void setClipToRegion(boolean value) {
		setParameter("clip_to_region", (Object) value);
	}

	/**
	 *  Clip to chunk region.
	 */
	public boolean getClipToRegion() {
		return (boolean) getParameter("clip_to_region");
	}

	/**
	 *  Copy orthophotos (orthomosaic asset type only).
	 */
	public void setCopyOrthophotos(boolean value) {
		setParameter("copy_orthophotos", (Object) value);
	}

	/**
	 *  Copy orthophotos (orthomosaic asset type only).
	 */
	public boolean getCopyOrthophotos() {
		return (boolean) getParameter("copy_orthophotos");
	}

	/**
	 *  Copy patches.
	 */
	public void setCopyPatches(boolean value) {
		setParameter("copy_patches", (Object) value);
	}

	/**
	 *  Copy patches.
	 */
	public boolean getCopyPatches() {
		return (boolean) getParameter("copy_patches");
	}

}
