package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class ImportPointCloud extends Task {

	public ImportPointCloud() {
		super("ImportPointCloud");
	}

	/**
	 *  Calculate point normals.
	 */
	public void setCalculateNormals(boolean value) {
		setParameter("calculate_normals", (Object) value);
	}

	/**
	 *  Calculate point normals.
	 */
	public boolean getCalculateNormals() {
		return (boolean) getParameter("calculate_normals");
	}

	/**
	 *  Column order (x/y/z - coordinates, X/Y/Z - normal, r/g/b - color, i - intensity, t - time, c - classification, space - skip column).
	 */
	public void setColumns(String value) {
		setParameter("columns", (Object) value);
	}

	/**
	 *  Column order (x/y/z - coordinates, X/Y/Z - normal, r/g/b - color, i - intensity, t - time, c - classification, space - skip column).
	 */
	public String getColumns() {
		return (String) getParameter("columns");
	}

	/**
	 *  Point cloud coordinate system.
	 */
	public void setCRS(CoordinateSystem value) {
		setParameter("crs", (Object) value);
	}

	/**
	 *  Point cloud coordinate system.
	 */
	public CoordinateSystem getCRS() {
		return (CoordinateSystem) getParameter("crs");
	}

	/**
	 *  CSV delimiter.
	 */
	public void setDelimiter(String value) {
		setParameter("delimiter", (Object) value);
	}

	/**
	 *  CSV delimiter.
	 */
	public String getDelimiter() {
		return (String) getParameter("delimiter");
	}

	/**
	 *  Point cloud format. Default: PointCloudFormat.PointCloudFormatNone
	 */
	public void setFormat(PointCloudFormat value) {
		setParameter("format", (Object) value);
	}

	/**
	 *  Point cloud format. Default: PointCloudFormat.PointCloudFormatNone
	 */
	public PointCloudFormat getFormat() {
		return (PointCloudFormat) getParameter("format");
	}

	/**
	 *  List of point cloud paths to import in each frame of a multiframe chunk.
	 */
	public void setFramePaths(String[] value) {
		setParameter("frame_paths", (Object) value);
	}

	/**
	 *  List of point cloud paths to import in each frame of a multiframe chunk.
	 */
	public String[] getFramePaths() {
		return (String[]) getParameter("frame_paths");
	}

	/**
	 *  Generate panorama from point colors.
	 */
	public void setGeneratePanorama(boolean value) {
		setParameter("generate_panorama", (Object) value);
	}

	/**
	 *  Generate panorama from point colors.
	 */
	public boolean getGeneratePanorama() {
		return (boolean) getParameter("generate_panorama");
	}

	/**
	 *  Combine consecutive delimiters in csv format.
	 */
	public void setGroupDelimiters(boolean value) {
		setParameter("group_delimiters", (Object) value);
	}

	/**
	 *  Combine consecutive delimiters in csv format.
	 */
	public boolean getGroupDelimiters() {
		return (boolean) getParameter("group_delimiters");
	}

	/**
	 *  Do not use laser scan origin as scanner position for structured point clouds.
	 */
	public void setIgnoreScannerOrigin(boolean value) {
		setParameter("ignore_scanner_origin", (Object) value);
	}

	/**
	 *  Do not use laser scan origin as scanner position for structured point clouds.
	 */
	public boolean getIgnoreScannerOrigin() {
		return (boolean) getParameter("ignore_scanner_origin");
	}

	/**
	 *  Do not attach trajectory to imported point cloud.
	 */
	public void setIgnoreTrajectory(boolean value) {
		setParameter("ignore_trajectory", (Object) value);
	}

	/**
	 *  Do not attach trajectory to imported point cloud.
	 */
	public boolean getIgnoreTrajectory() {
		return (boolean) getParameter("ignore_trajectory");
	}

	/**
	 *  Import point clouds as laser scans.
	 */
	public void setIsLaserScan(boolean value) {
		setParameter("is_laser_scan", (Object) value);
	}

	/**
	 *  Import point clouds as laser scans.
	 */
	public boolean getIsLaserScan() {
		return (boolean) getParameter("is_laser_scan");
	}

	/**
	 *  Import images embedded in laser scan.
	 */
	public void setLoadImages(boolean value) {
		setParameter("load_images", (Object) value);
	}

	/**
	 *  Import images embedded in laser scan.
	 */
	public boolean getLoadImages() {
		return (boolean) getParameter("load_images");
	}

	/**
	 *  Import point classification.
	 */
	public void setLoadPointClassification(boolean value) {
		setParameter("load_point_classification", (Object) value);
	}

	/**
	 *  Import point classification.
	 */
	public boolean getLoadPointClassification() {
		return (boolean) getParameter("load_point_classification");
	}

	/**
	 *  Import point color.
	 */
	public void setLoadPointColor(boolean value) {
		setParameter("load_point_color", (Object) value);
	}

	/**
	 *  Import point color.
	 */
	public boolean getLoadPointColor() {
		return (boolean) getParameter("load_point_color");
	}

	/**
	 *  Import point confidence.
	 */
	public void setLoadPointConfidence(boolean value) {
		setParameter("load_point_confidence", (Object) value);
	}

	/**
	 *  Import point confidence.
	 */
	public boolean getLoadPointConfidence() {
		return (boolean) getParameter("load_point_confidence");
	}

	/**
	 *  Import point row and column indices.
	 */
	public void setLoadPointIndex(boolean value) {
		setParameter("load_point_index", (Object) value);
	}

	/**
	 *  Import point row and column indices.
	 */
	public boolean getLoadPointIndex() {
		return (boolean) getParameter("load_point_index");
	}

	/**
	 *  Import point intensity.
	 */
	public void setLoadPointIntensity(boolean value) {
		setParameter("load_point_intensity", (Object) value);
	}

	/**
	 *  Import point intensity.
	 */
	public boolean getLoadPointIntensity() {
		return (boolean) getParameter("load_point_intensity");
	}

	/**
	 *  Import point normal.
	 */
	public void setLoadPointNormal(boolean value) {
		setParameter("load_point_normal", (Object) value);
	}

	/**
	 *  Import point normal.
	 */
	public boolean getLoadPointNormal() {
		return (boolean) getParameter("load_point_normal");
	}

	/**
	 *  Import point return number.
	 */
	public void setLoadPointReturnNumber(boolean value) {
		setParameter("load_point_return_number", (Object) value);
	}

	/**
	 *  Import point return number.
	 */
	public boolean getLoadPointReturnNumber() {
		return (boolean) getParameter("load_point_return_number");
	}

	/**
	 *  Import point scan angle.
	 */
	public void setLoadPointScanAngle(boolean value) {
		setParameter("load_point_scan_angle", (Object) value);
	}

	/**
	 *  Import point scan angle.
	 */
	public boolean getLoadPointScanAngle() {
		return (boolean) getParameter("load_point_scan_angle");
	}

	/**
	 *  Import point source ID.
	 */
	public void setLoadPointSourceId(boolean value) {
		setParameter("load_point_source_id", (Object) value);
	}

	/**
	 *  Import point source ID.
	 */
	public boolean getLoadPointSourceId() {
		return (boolean) getParameter("load_point_source_id");
	}

	/**
	 *  Import point timestamp.
	 */
	public void setLoadPointTimestamp(boolean value) {
		setParameter("load_point_timestamp", (Object) value);
	}

	/**
	 *  Import point timestamp.
	 */
	public boolean getLoadPointTimestamp() {
		return (boolean) getParameter("load_point_timestamp");
	}

	/**
	 *  Path to point cloud.
	 */
	public void setPath(String value) {
		setParameter("path", (Object) value);
	}

	/**
	 *  Path to point cloud.
	 */
	public String getPath() {
		return (String) getParameter("path");
	}

	/**
	 *  Number of point neighbors to use for normal estimation. Default: 28
	 */
	public void setPointNeighbors(int value) {
		setParameter("point_neighbors", (Object) value);
	}

	/**
	 *  Number of point neighbors to use for normal estimation. Default: 28
	 */
	public int getPointNeighbors() {
		return (int) getParameter("point_neighbors");
	}

	/**
	 *  Coordinate precision (m). For default precision use 0. Default: 0.0
	 */
	public void setPrecision(double value) {
		setParameter("precision", (Object) value);
	}

	/**
	 *  Coordinate precision (m). For default precision use 0. Default: 0.0
	 */
	public double getPrecision() {
		return (double) getParameter("precision");
	}

	/**
	 *  Replace default asset with imported point cloud.
	 */
	public void setReplaceAsset(boolean value) {
		setParameter("replace_asset", (Object) value);
	}

	/**
	 *  Replace default asset with imported point cloud.
	 */
	public boolean getReplaceAsset() {
		return (boolean) getParameter("replace_asset");
	}

	/**
	 *  Use laser scan origin as scanner position for unstructured point clouds.
	 */
	public void setScannerAtOrigin(boolean value) {
		setParameter("scanner_at_origin", (Object) value);
	}

	/**
	 *  Use laser scan origin as scanner position for unstructured point clouds.
	 */
	public boolean getScannerAtOrigin() {
		return (boolean) getParameter("scanner_at_origin");
	}

	/**
	 *  Optional shift to be applied to point coordinates.
	 */
	public void setShift(Vector value) {
		setParameter("shift", (Object) value);
	}

	/**
	 *  Optional shift to be applied to point coordinates.
	 */
	public Vector getShift() {
		return (Vector) getParameter("shift");
	}

	/**
	 *  Number of rows to skip. Default: 0
	 */
	public void setSkipRows(int value) {
		setParameter("skip_rows", (Object) value);
	}

	/**
	 *  Number of rows to skip. Default: 0
	 */
	public int getSkipRows() {
		return (int) getParameter("skip_rows");
	}

	/**
	 *  Trajectory key to attach.
	 */
	public void setTrajectory(int value) {
		setParameter("trajectory", (Object) value);
	}

	/**
	 *  Trajectory key to attach.
	 */
	public int getTrajectory() {
		return (int) getParameter("trajectory");
	}

}
