package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class RenderDepthMaps extends Task {

	public RenderDepthMaps() {
		super("RenderDepthMaps");
	}

	/**
	 *  List of cameras to process.
	 */
	public void setCameras(int[] value) {
		setParameter("cameras", (Object) value);
	}

	/**
	 *  List of cameras to process.
	 */
	public int[] getCameras() {
		return (int[]) getParameter("cameras");
	}

	/**
	 *  Path to depth map.
	 */
	public void setPathDepth(String value) {
		setParameter("path_depth", (Object) value);
	}

	/**
	 *  Path to depth map.
	 */
	public String getPathDepth() {
		return (String) getParameter("path_depth");
	}

	/**
	 *  Path to diffuse map.
	 */
	public void setPathDiffuse(String value) {
		setParameter("path_diffuse", (Object) value);
	}

	/**
	 *  Path to diffuse map.
	 */
	public String getPathDiffuse() {
		return (String) getParameter("path_diffuse");
	}

	/**
	 *  Path to normal map.
	 */
	public void setPathNormals(String value) {
		setParameter("path_normals", (Object) value);
	}

	/**
	 *  Path to normal map.
	 */
	public String getPathNormals() {
		return (String) getParameter("path_normals");
	}

	/**
	 *  Enable export of depth map.
	 */
	public void setSaveDepth(boolean value) {
		setParameter("save_depth", (Object) value);
	}

	/**
	 *  Enable export of depth map.
	 */
	public boolean getSaveDepth() {
		return (boolean) getParameter("save_depth");
	}

	/**
	 *  Enable export of diffuse map.
	 */
	public void setSaveDiffuse(boolean value) {
		setParameter("save_diffuse", (Object) value);
	}

	/**
	 *  Enable export of diffuse map.
	 */
	public boolean getSaveDiffuse() {
		return (boolean) getParameter("save_diffuse");
	}

	/**
	 *  Enable export of normal map.
	 */
	public void setSaveNormals(boolean value) {
		setParameter("save_normals", (Object) value);
	}

	/**
	 *  Enable export of normal map.
	 */
	public boolean getSaveNormals() {
		return (boolean) getParameter("save_normals");
	}

}
