#!/bin/sh
dirname=`dirname "$0"`
tmp="${dirname#?}"

if [ "${dirname%$tmp}" != "/" ]; then
dirname=$PWD/$dirname
fi

dirname=`realpath $dirname`

echo "#!/usr/bin/env xdg-open

[Desktop Entry]
Type=Application
Terminal=false
Exec=$dirname/metashape.sh
Icon=$dirname/metashape.png
Name=Agisoft Metashape Professional
Comment=Surface reconstruction from photos
Categories=Science;
StartupWMClass=Metashape Pro" > "/tmp/agisoft-metashape-pro.desktop"

xdg-desktop-menu install /tmp/agisoft-metashape-pro.desktop

rm /tmp/agisoft-metashape-pro.desktop

echo "#!/usr/bin/env xdg-open

[Desktop Entry]
Type=Application
Terminal=false
Exec=$dirname/viewer.sh
Icon=$dirname/viewer.png
Name=Agisoft Viewer
Comment=View 3D data
Categories=Science;
StartupWMClass=Viewer" > "/tmp/agisoft-viewer.desktop"

xdg-desktop-menu install /tmp/agisoft-viewer.desktop

rm /tmp/agisoft-viewer.desktop

echo "#!/usr/bin/env xdg-open

[Desktop Entry]
Type=Application
Terminal=false
Exec=$dirname/monitor.sh
Icon=$dirname/monitor.png
Name=Agisoft Network Monitor
Comment=Manage Metashape cluster
Categories=Science;
StartupWMClass=Monitor" > "/tmp/agisoft-monitor.desktop"

xdg-desktop-menu install /tmp/agisoft-monitor.desktop

rm /tmp/agisoft-monitor.desktop

xdg-desktop-menu forceupdate