#!/bin/bash
# Verwendungsinfo speichern
usage="Verwendung: $0 -a|-d <Datei>"
# Versionsinfo speichern
version="$0 Version 0.01"
# Datum und Uhrzeit speichern
$jetzt=`date "+%d.%m.%Y, %H:%M"`
case $1 in
-a)
  # Testen, ob $2 berhaupt eine regulre Datei ist
  # (ansonsten Ende mit Fehlermeldung)
  if [ -f $2 ]
  then
    echo $0 war hier am $jetzt >>$2
  else
    echo $0: $2 ist keine Datei
    exit 1
  fi
  ;;
-d)
  # Testen, ob $2 berhaupt eine regulre Datei ist
  # (ansonsten Ende mit Fehlermeldung)
  if [ -f $2 ]
  then
    rm $2
  else
    echo $0: $2 ist keine Datei
    exit 1
  fi
  ;;
-v)
  echo $version
  ;;
-h)
  echo $usage
  ;;
*)
  echo Ungltiger Aufruf
  echo $usage
  exit 1
  ;;
esac
