#!/usr/bin/perl -w
use strict;

# *****************************************
# * Skript: log_stat.pl                   *
# * Einfache Statistik fr Web-Logdateien *
# *****************************************

# Namen der Logdatei von der Kommandozeile lesen
my $logfile = $ARGV[0] || die "Verwendung: $0 Logdatei [Max]\n";
# Gewnschte Hchst-Zeilenzahl lesen oder auf 20 setzen
my $maxlines = $ARGV[1] || 20;

# Versuchen, die Logdatei zu ffnen
open (LOG, "<$logfile") || die "Kann $logfile nicht ffnen\n";

# Arrays fr die Logdatei-Bestandteile
my (@hosts, @ids, @uids, @dates, @requests, @status, @sizes, @referers, @useragents);

# Zeilenweise einlesen und auswerten
while (my $line = <LOG>) {
   chomp $line;
   if ($line =~ /^([^\s]+)\s+([^\s]+)\s+([^\s]+)\s+
           \[([^\]]+)\]\s+"([^"]+)"\s+(\d+)\s+([\d\-]+)$/) {
      push @hosts, $1;
      push @ids, $2;
      push @uids, $3;
      push @dates, $4;
      push @requests, $5;
      push @status, $6;
      push @sizes, $7;
      push @referers, "-";
      push @useragents, "-";
   } elsif ($line =~ /^([^\s]+)\s+([^\s]+)\s+([^\s]+)\s+
            \[([^\]]+)\]\s+"([^"]+)"\s+(\d+)\s+([\d\-]+)\s+
            "([^"]+)"\s+"([^"]+)"/) {
      push @hosts, $1;
      push @ids, $2;
      push @uids, $3;
      push @dates, $4;
      push @requests, $5;
      push @status, $6;
      push @sizes, $7;
      push @referers, $8;
      push @useragents, $9;
   }
}

# Anzahlen unterschiedlicher Hosts ermitteln
my %sorthosts;
foreach my $host(@hosts) {
   # Im Hash %sorthosts ist der Host der Schlssel;
   # der Wert dient als Zhler und wird um 1 erhht
   $sorthosts{$host}++;
}
print "Die (bis zu) $maxlines haeufigsten Besucher:\n\n";
my $c = 1;
foreach my $host 
   (sort {$sorthosts{$b} <=> $sorthosts{$a}} (keys %sorthosts)) {
   print "$c. $host: ${sorthosts{$host}}\n";
   $c++;
   last if $c > $maxlines; 
}
print "\n";

# Anzahlen unterschiedlicher erfolgreich angeforderter URLs
my %sorturls;
my $i = 0;
foreach my $request(@requests) {
   # URL aus dem Request ermitteln
   my $url;
   if ($request =~ /[A-Z]+\s+([^\s]+)/) {
      $url = $1;
   }
   # War diese Anfrage erfolgreich?
   if ($status[$i] == 200) {
      # URL zhlen
      $sorturls{$url}++;
   }
   $i++;
}
print "Die (bis zu) $maxlines haeufigsten erfolgreichen Anfragen:\n\n";
$c = 1;
foreach my $url 
   (sort {$sorturls{$b} <=> $sorturls{$a}} (keys %sorturls)) {
   print "$c. $url: ${sorturls{$url}}\n";
   $c++;
   last if $c > $maxlines;
}
