#!/bin/bash
# Verzeichnis aus Kommandozeilenparameter lesen
# oder auf '.' (akt. Verzeichnis) setzen
testdir=$1 || testdir=.
# Original-Eingabeseparator speichern
ifscopy=$IFS
# Eingabeseparator auf Zeilenumbrche beschrnken
IFS=$'\n'
# Zhlervariablen inititalisieren
let direcs=0
let links=0
let files=0
for entry in `ls -l $testdir |sort`
do
  case $entry in
d*)
    # Verzeichnis
    let direcs=$direcs+1
    ;;
l*)
    # Symlink
    let links=$links+1
    ;;
-*)
    # Normale Datei
    let files=$files+1
    ;;
  esac
done
# Eingabeseparator zurcksetzen
IFS=$ifscopy
echo $direcs Verzeichnisse.
echo $files normale Dateien.
echo $links Symlinks.
