#!/usr/bin/perl -w
use strict;
use IO::Socket;

# Host von Kommandozeile oder localhost
my $host = $ARGV[0] || "localhost";

# Server-Verbindung
my $sock = IO::Socket::INET->new
   (Proto    => 'tcp',
    PeerAddr => $host,
    PeerPort => 11111);
    
print "<0> zurcksetzen, <X> beenden, <Enter> Info.\n";

# Kommunikations-Schleife
while (1) {
   print "> ";
   my $eingabe = <>;
   chomp $eingabe;
   
   # Je nach Eingabe Befehle an den Server senden
   
   if ($eingabe eq '0') {
      # Zhler zurcksetzen
      print $sock "reset\n";
   } elsif ($eingabe =~ /^x$/i) {
      # Verbindung beenden
      print $sock "exit\n";
   } else {
      # Normal: Anzahl/Datum erfragen
      print $sock "$eingabe\n";
   }
   
   # Serverantwort lesen
   my $antwort = <$sock>;
   $antwort =~ s/\s*$//;
   
   print "Antwort von $host: $antwort\n";
   
   # Beenden?
   last if $eingabe =~ /^x$/i;
}
