#!/usr/bin/perl -w
use strict;
use IO::Socket;

# Lauschendes Socket erzeugen
my $listen = IO::Socket::INET->new
   (Proto     => 'TCP',
    LocalPort => 11111,
    Listen    => SOMAXCONN);

print "Server lauscht an Port 11111 ...\n";

# Logdatei zum Anhngen ffnen
open LOG, ">>log.txt";

# Accept-Schleife
while (1) {
   # Keine Anfrage? Nchster Durchlauf!
   next unless my $conn = $listen->accept();
   
   # Verbindungsaufbau - Child-Prozess erzeugen
   my $child = fork;
   if ($child == 0) {
      # Im Child-Prozess? Verbindung verarbeiten
      handle_conn ($conn);
      # Wieder da? Child beenden
      exit (0);
   }
}

sub handle_conn {

   my $anzahl = 0;
   
   my $sock = shift;
   my $peer = $sock->peerhost;
   
   print "  Connection from $peer\n";
   
   # Anfragen lesen
   while (my $request = <$sock>) {
      $request =~ s/\s*$//;
      # Beenden bei "exit"
      last if $request eq "exit";
      # reset?
      $anzahl = 0 if $request eq "reset";
      # Datum und Uhrzeit
      my $now = scalar localtime;
      # Anzahl erhhen
      $anzahl++;
      # Ausgabe
      print $sock "${anzahl}. Anfrage: $now\n";
      # Log-Eintrag
      print LOG "${peer}: \"${request}\" ($now)\n";
   }
   print $sock "Bye.\n";
   print "  Connection closed by $peer\n";
}
