// copyright 2000 Eric Gunnerson
using System;
using System.Threading;

public class Account
{
    public Account(decimal balance)
    {
        this.balance = balance;
    }    
    
    public void Deposit(decimal amount)
    {
        lock(this)     // uncomment to protect block.
        {
            Decimal temp = balance;
            temp += amount;
            Thread.Sleep(1);     // deliberately wait
            balance = temp;
        }
    }
    public Decimal Balance
    {
        get
        {
            return(balance);
        }
    }
    decimal balance;
}

class ThreadTest
{
    public void MakeDeposit()
    {
        for (int i = 0; i < 10; i++)
        account.Deposit(10);
    }
    
    public static void Main(string[] args)
    {
        ThreadTest b = new ThreadTest();
        Thread t = null;
            // create 10 threads. 
        for (int threads = 0; threads < 10; threads++)
        {
            t = new Thread(new ThreadStart(b.MakeDeposit));
            t.Start();
        }
        t.Join();     // wait for last thread to finish
        Console.WriteLine("Balance: {0}", b.account.Balance);
    }
    Account    account = new Account(0);
}