﻿
/*
 * 
 * 
 * original jQuery toggle
 *
 *
 */


(function( $ ){
  $.fn.originalToggle = function( fn, fn2 ) {
    var args = arguments,guid = fn.guid || $.guid++,i=0,
    toggler = function( event ) {
      var lastToggle = ( $._data( this, "lastToggle" + fn.guid ) || 0 ) % i;
      $._data( this, "lastToggle" + fn.guid, lastToggle + 1 );
      event.preventDefault();
      return args[ lastToggle ].apply( this, arguments ) || false;
    };
    toggler.guid = guid;
    while ( i < args.length ) {
      args[ i++ ].guid = guid;
    }
    return this.click( toggler );
  };
})( jQuery );


/*
 * 
 * 
 * Alternative toggle
 *
 *
 */


(function( $ ){
	$.fn.selfmadeToggle = function(){

		var functions = arguments ;

		return this.click(function(e){
			e.preventDefault();
 			var iteration = $(this).data('iteration') || 0;
			functions[iteration].apply(this, arguments);
			iteration = (iteration + 1) % functions.length ;
			$(this).data('iteration', iteration);
		});
	};
})( jQuery );


/*
 * 
 * 
 * click toggle
 *
 *
 */



	var tree = {
	
		init: function() {

			var $obj = $("#menu");

			if (!$obj.length) return;
			$obj.find("ul").each(function() {
				$(this).css("display", "none");
			});
			$("li:not(:has(ul))").find("a").addClass("leaf");
			$obj.find("a").selfmadeToggle(function() {
				$(this).parent().find("ul:first").slideDown(400);
				tree.classManager($(this));
			},function() {
				$(this).parent().find("ul:first").slideUp(400);
				tree.classManager($(this));
			});
			$obj.find("a").dblclick( function() {
				window.location = $(this).attr("href");
			});
		},
		classManager: function($obj) {
			if (!$obj.hasClass("leaf")) {
				$obj.toggleClass("selected");
			}
		}

	};
$(document).ready(tree.init);