
/*
// Weg 1
$(document).ready(function() {
	
	var box = $(".box");
	var resize = function() {
		box.css({
			top:( $(window).height() - box.outerHeight() ) / 2,
			left:($(window).width() - box.outerWidth()) / 2
		});
	};
	resize();
	
	$(window).on('resize',function() {
		resize()
	});
		
});


// Weg 2:

var center = {
	
	init: function(settings) {

		center.$obj = $(".box");

		$.extend( center.$obj, settings );

		if (!center.$obj.length) return;
	
		$(window).on('resize',function() {
			center.resize()
		});
		center.resize(); 
	},
		
	getSize: function($this) {
		return { width: $this.outerWidth(), height: $this.outerHeight() };
	},

	getWindow: function() {
		return center.getSize($(window));
	},

	getItem: function() {
		return center.getSize(center.$obj);
	},
	
	resize: function() {
		console.log("resize");
		var top = (center.getWindow().height - center.getItem().height ) / 2;
		var left = (center.getWindow().width - center.getItem().width) / 2;
		center.$obj.css({top:top,left:left});
	}

	

};

$(document).ready(function() {
	center.init();
	console.log(center.getSize($(".box img")) );
});

*/


// Weg 3

var center = (function(){
	
	var $obj;
	
	var init = function(settings) {

		$obj = $(".box");

		$.extend( $obj, settings );

		if (!$obj.length) return;
	
		resize(); 
		
		$(window).on('resize',function() {
			resize();
		});
	
	};

	var getSize = function($this) {
		return { width: $this.outerWidth(), height: $this.outerHeight() };
	};

	var getWindow = function() {
		return getSize($(window));
	};

	var getItem = function() {
		return getSize($obj);
	};
	
	var resize = function() {
		var top = (getWindow().height - getItem().height ) / 2;
		var left = (getWindow().width - getItem().width) / 2;
		$obj.css({top:top,left:left});
	};

	return {
		init:init
	}	

})();

$(window).on('load', function() {
	center.init();
});
	


