﻿
var slideshow = {
	
	init: function(settings) {

		slideshow.config = {
			$images: $(".slideshow img"),
			interval: 3000
		}
		$.extend( slideshow.config, settings );	

		if (slideshow.getImages().length <= 1) return;

		slideshow.getImages().parent().addClass("loading");
		slideshow.getImages().hide();
	
		slideshow.getImages().imagesLoaded(function() {
			slideshow.start();
		});
	},

	getImages: function() {
		return slideshow.config.$images;
	},
	
	loop: function() {
		slideshow.blend();
		setTimeout(slideshow.loop, slideshow.config.interval );
	},
	blend: function() {
		var current = slideshow.getImages().filter(".current")
			.fadeOut("slow")
			.removeClass("current");
		current = (current.next().length) ?
		current.next() : slideshow.getImages().first();
		current.fadeIn("slow").addClass("current");
	},
	getLargest: function(array) {
		return Math.max.apply( Math, array );
	},
	

	start: function() {
		var array = [];
		slideshow.getImages().hide();
		slideshow.getImages().each(function() {
			array.push($(this).height());
		});
		slideshow.getImages().parent().animate({height:slideshow.getLargest(array)},"fast");
		slideshow.getImages().parent().removeClass("loading");
		slideshow.getImages().first().fadeIn("slow",function() {
			setTimeout(slideshow.loop,slideshow.config.interval);
		}).addClass("current");
	}

}

$(document).ready(function() {
	slideshow.init({ 
		$images: $(".slideshow img"),
		interval: 4000
	});
});
